/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.privatelan.model;

/**
 * タグ情報クラス。<br />
 * このクラスはタグ情報を格納します。
 */

public class Tag {

	/** 設定されているタグのキー */
	private String key;

	/** 設定されているタグの値 */
	private String value;

	/**
	 * 設定されているタグのキーを取得します。
	 * @return key
	 */
	public String getKey() {
	    return key;
	}

	/**
	 * 設定されているタグのキーを設定します。
	 * @param Key 設定されているタグのキー
	 */
	public void setKey(String key) {
	    this.key = key;
	}
	/**
	 * 設定されているタグのキーを設定し、自オブジェクトを返します。
	 *
	 * @param key 設定されているタグのキー
	 * @return 自オブジェクト
	 */
	public Tag withKey(String key) {
		setKey(key);
		return this;
	}

	/**
	 * 設定されているタグの値を取得します。
	 * @return value
	 */
	public String getValue() {
	    return value;
	}

	/**
	 * 設定されているタグの値を設定します。
	 * @param value 設定されているタグの値
	 */
	public void setValue(String value) {
	    this.value = value;
	}
	/**
	 * 設定されているタグのキーを設定し、自オブジェクトを返します。
	 *
	 * @param value 設定されているタグの値
	 * @return 自オブジェクト
	 */
	public Tag withValue(String value) {
		setValue(value);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[key=");
		builder.append(key);
		builder.append(", value=");
		builder.append(value);
		builder.append("]");
		return builder.toString();
	}
}
