/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.privatelan.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * プライベートLAN情報クラス。<br />
 * このクラスはプライベートLAN情報を格納します。
 */
public class PrivateLan {

    /** ネットワークID */
    private String networkId;

    /** プライベートLAN名 */
    private String privateLanName;

    /** プライベートLANのステータス */
    private String state;

    /** プラベートLANのCIDR */
    private String cidrBlock;

    /** ゾーン情報 */
    private String availabilityZone;

    private List<Tag> tagSets;

    /** 利用料金タイプ */
    private String accountingType;

    /** 次月からの利用料金タイプ */
    private String nextMonthAccountingType;

    /** プライベートLANのメモ */
    private String description;

    /** プライベートLANに接続しているサーバー情報リスト */
    private List<Instance> instanceSets;

    /** プライベートLANに接続しているルーター情報リスト */
    private List<Router> routerSets;

    /** プライベートLANに接続しているVPNゲートウェイ情報リスト */
    private List<VpnGateway> vpnGatewaySets;
    
    /** マルチロードバランサーの情報リスト */
    private List<ElasticLoadBalancing> elasticLoadBalancingSets;

    /** ネットワークインターフェースの情報リスト */
    private List<NetworkInterface> networkInterfaceSets;

    /** 作成日時 */
    private String createdTime;

    /** 共有ステータス */
    private String sharingStatus;

    /**
     * ネットワークIDを取得します。
     * 
     * @return ネットワークID
     */
    public String getNetworkId() {
        return networkId;
    }

    /**
     * ネットワークIDを設定します。
     * 
     * @param networkid
     *            ネットワークID
     */
    public void setNetworkId(String networkId) {
        this.networkId = networkId;
    }

    /**
     * ネットワークIDを設定し、自オブジェクトを返します。
     *
     * @param networkId
     *            ネットワークID
     * @return 自オブジェクト
     */
    public PrivateLan withNetworkId(String networkId) {
        setNetworkId(networkId);
        return this;
    }

    /**
     * プライベートLAN名を取得します。
     * 
     * @return プライベートLAN名
     */
    public String getPrivateLanName() {
        return privateLanName;
    }

    /**
     * プライベートLAN名を設定します。
     * 
     * @param privateLanName
     *            プライベートLAN名
     */
    public void setPrivateLanName(String privateLanName) {
        this.privateLanName = privateLanName;
    }

    /**
     * プライベートLAN名を設定し、自オブジェクトを返します。
     *
     * @param privateLanName
     *            プライベートLAN名
     * @return 自オブジェクト
     */
    public PrivateLan withPrivateLanName(String privateLanName) {
        setPrivateLanName(privateLanName);
        return this;
    }

    /**
     * プライベートLANのステータスを取得します。
     * 
     * @return プライベートLANのステータス
     */
    public String getState() {
        return state;
    }

    /**
     * プライベートLANのステータスを設定します。
     * 
     * @param state
     *            プライベートLANのステータス
     */
    public void setState(String state) {
        this.state = state;
    }

    /**
     * プライベートLANのステータスを設定し、自オブジェクトを返します。
     *
     * @param state
     *            プライベートLANのステータス
     * @return 自オブジェクト
     */
    public PrivateLan withState(String state) {
        setState(state);
        return this;
    }

    /**
     * プラベートLANのCIDRを取得します。
     * 
     * @return プラベートLANのCIDR
     */
    public String getCidrBlock() {
        return cidrBlock;
    }

    /**
     * プラベートLANのCIDRを設定します。
     * 
     * @param cidrBlock
     *            プラベートLANのCIDR
     */
    public void setCidrBlock(String cidrBlock) {
        this.cidrBlock = cidrBlock;
    }

    /**
     * プラベートLANのCIDRを設定し、自オブジェクトを返します。
     *
     * @param cidrBlock
     *            プラベートLANのCIDR
     * @return 自オブジェクト
     */
    public PrivateLan withCidrBlock(String cidrBlock) {
        setCidrBlock(cidrBlock);
        return this;
    }

    /**
     * ゾーン情報を取得します。
     * 
     * @return ゾーン情報
     */
    public String getAvailabilityZone() {
        return availabilityZone;
    }

    /**
     * ゾーン情報を設定します。
     * 
     * @param availabilityZone
     *            ゾーン情報
     */
    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    /**
     * ゾーン情報を設定し、自オブジェクトを返します。
     *
     * @param availabilityZone
     *            ゾーン情報
     * @return 自オブジェクト
     */
    public PrivateLan withAvailabilityZone(String availabilityZone) {
        setAvailabilityZone(availabilityZone);
        return this;
    }

    /**
     * tagSetを取得します。
     * 
     * @return tagSets
     */
    public List<Tag> getTagSets() {
        return tagSets;
    }

    /**
     * tagSetを設定します。
     * 
     * @param tagSets
     */
    public void setTagSets(List<Tag> tagSets) {
        this.tagSets = tagSets;
    }

    /**
     * tagSetsの配列を設定し、自オブジェクトを返します。
     *
     * @param tagSets
     * @return 自オブジェクト
     */
    public PrivateLan withTagSets(Tag... tagSets) {
        if (this.tagSets == null)
            this.tagSets = new ArrayList<Tag>();
        for (Tag tagSet : tagSets) {
            getTagSets().add(tagSet);
        }
        return this;
    }

    /**
     * tagSetsのリストを設定し、自オブジェクトを返します。
     *
     * @param tagSets
     * @return 自オブジェクト
     */
    public PrivateLan withTagSets(Collection<Tag> tagSets) {
        if (this.tagSets == null)
            this.tagSets = new ArrayList<Tag>();
        if (tagSets != null) {
            getTagSets().addAll(tagSets);
        }
        return this;
    }

    /**
     * 利用料金タイプを取得します。
     * 
     * @return 利用料金タイプ
     */
    public String getAccountingType() {
        return accountingType;
    }

    /**
     * 利用料金タイプを設定します。
     * 
     * @param accountingType
     *            利用料金タイプ
     */
    public void setAccountingType(String accountingType) {
        this.accountingType = accountingType;
    }

    /**
     * 利用料金タイプを設定し、自オブジェクトを返します。
     *
     * @param accountingType
     *            利用料金タイプ
     * @return 自オブジェクト
     */
    public PrivateLan withAccountingType(String accountingType) {
        setAccountingType(accountingType);
        return this;
    }

    /**
     * 次月からの利用料金タイプを取得します。
     * 
     * @return 利用料金タイプ
     */
    public String getNextMonthAccountingType() {
        return nextMonthAccountingType;
    }

    /**
     * 利用料金タイプを設定します。
     * 
     * @param accountingType
     *            利用料金タイプ
     */
    public void setNextMonthAccountingType(String nextMonthAccountingType) {
        this.nextMonthAccountingType = nextMonthAccountingType;
    }

    /**
     * 利用料金タイプを設定し、自オブジェクトを返します。
     *
     * @param nextAccountingType
     *            利用料金タイプ
     * @return 自オブジェクト
     */
    public PrivateLan withnNextMonthAccountingType(String nextMonthAccountingType) {
        setNextMonthAccountingType(nextMonthAccountingType);
        return this;
    }

    /**
     * プライベートLANのメモを取得します。
     * 
     * @return プライベートLANのメモ
     */
    public String getDescription() {
        return description;
    }

    /**
     * プライベートLANのメモを設定します。
     * 
     * @param description
     *            プライベートLANのメモ
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * プライベートLANのメモを設定し、自オブジェクトを返します。
     *
     * @param description
     *            プライベートLANのメモ
     * @return 自オブジェクト
     */
    public PrivateLan withDescription(String description) {
        setDescription(description);
        return this;
    }

    /**
     * プライベートLANに接続しているサーバー情報リストを取得します。
     * 
     * @return instanceSets
     */
    public List<Instance> getInstanceSets() {
        return instanceSets;
    }

    /**
     * プライベートLANに接続しているサーバー情報リストを設定します。
     * 
     * @param instanceSets
     *            プライベートLANに接続しているサーバー情報リスト
     */
    public void setInstanceSets(List<Instance> instanceSets) {
        this.instanceSets = instanceSets;
    }

    /**
     * プライベートLANに接続しているサーバー情報の配列を設定し、自オブジェクトを返します。
     *
     * @param instanceSets
     *            プライベートLANに接続しているサーバー情報
     * @return 自オブジェクト
     */
    public PrivateLan withInstanceSets(Instance... instanceSets) {
        if (this.instanceSets == null)
            this.instanceSets = new ArrayList<Instance>();
        for (Instance instanceSet : instanceSets) {
            getInstanceSets().add(instanceSet);
        }
        return this;
    }

    /**
     * プライベートLANに接続しているサーバー情報リストを設定し、自オブジェクトを返します。
     *
     * @param instanceSets
     *            プライベートLANに接続しているサーバー情報リスト
     * @return 自オブジェクト
     */
    public PrivateLan withInstanceSets(Collection<Instance> instanceSets) {
        if (this.instanceSets == null)
            this.instanceSets = new ArrayList<Instance>();
        if (instanceSets != null) {
            getInstanceSets().addAll(instanceSets);
        }
        return this;
    }

    /**
     * プライベートLANに接続しているルーター情報リストを取得します。
     * 
     * @return routerSets
     */
    public List<Router> getRouterSets() {
        return routerSets;
    }

    /**
     * プライベートLANに接続しているルーター情報リストを設定します。
     * 
     * @param routerSets
     *            プライベートLANに接続しているルーター情報リスト
     */
    public void setRouterSets(List<Router> routerSets) {
        this.routerSets = routerSets;
    }

    /**
     * プライベートLANに接続しているルーター情報の配列を設定し、自オブジェクトを返します。
     *
     * @param routerSets
     *            ルーターの情報の配列
     * @return 自オブジェクト
     */
    public PrivateLan withRouterSets(Router... routerSets) {
        if (this.routerSets == null)
            this.routerSets = new ArrayList<Router>();
        for (Router routerSet : routerSets) {
            getRouterSets().add(routerSet);
        }
        return this;
    }

    /**
     * プライベートLANに接続しているルーター情報リストを設定し、自オブジェクトを返します。
     *
     * @param routerSets
     *            プライベートLANに接続しているルーター情報リスト
     * @return 自オブジェクト
     */
    public PrivateLan withRouterSets(Collection<Router> routerSets) {
        if (this.routerSets == null)
            this.routerSets = new ArrayList<Router>();
        if (routerSets != null) {
            getRouterSets().addAll(routerSets);
        }
        return this;
    }

    /**
     * ネットワークインターフェースの情報リストを取得します。
     * 
     * @return ネットワークインターフェースの情報リスト
     */
    public List<NetworkInterface> getNetworkInterfaceSets() {
        return networkInterfaceSets;
    }

    /**
     * ネットワークインターフェースの情報リストを設定します。
     * 
     * @param networkInterfaceSets
     *            ネットワークインターフェースの情報リスト
     */
    public void setNetworkInterfaceSets(List<NetworkInterface> networkInterfaceSets) {
        this.networkInterfaceSets = networkInterfaceSets;
    }

    /**
     * ネットワークインターフェースの情報の配列を設定し、自オブジェクトを返します。
     *
     * @param networkInterfaceSets
     *            ネットワークインターフェースの情報リストの配列
     * @return 自オブジェクト
     */
    public PrivateLan withNetworkInterfaceSets(NetworkInterface... networkInterfaceSets) {
        if (this.networkInterfaceSets == null)
            this.networkInterfaceSets = new ArrayList<NetworkInterface>();
        for (NetworkInterface networkInterfaceSet : networkInterfaceSets) {
            getNetworkInterfaceSets().add(networkInterfaceSet);
        }
        return this;
    }

    /**
     * ネットワークインターフェースの情報リストを設定し、自オブジェクトを返します。
     *
     * @param networkInterfaceSets
     *            ネットワークインターフェースの情報リスト
     * @return 自オブジェクト
     */
    public PrivateLan withNetworkInterfaceSets(Collection<NetworkInterface> networkInterfaceSets) {
        if (this.networkInterfaceSets == null)
            this.networkInterfaceSets = new ArrayList<NetworkInterface>();
        if (networkInterfaceSets != null) {
            getNetworkInterfaceSets().addAll(networkInterfaceSets);
        }
        return this;
    }

    /**
     * プライベートLANに接続しているVPNゲートウェイ情報リストを取得します。
     * 
     * @return vpnGatewaySets
     */
    public List<VpnGateway> getVpnGatewaySets() {
        return vpnGatewaySets;
    }

    /**
     * プライベートLANに接続しているVPNゲートウェイ情報リストを設定します。
     * 
     * @param vpnGatewaySets
     *            プライベートLANに接続しているVPNゲートウェイ情報リスト
     */
    public void setVpnGatewaySets(List<VpnGateway> vpnGatewaySets) {
        this.vpnGatewaySets = vpnGatewaySets;
    }

    /**
     * プライベートLANに接続しているVPNゲートウェイ情報の配列を設定し、自オブジェクトを返します。
     *
     * @param vpnGatewaySets
     *            プライベートLANに接続しているVPNゲートウェイ情報
     * @return 自オブジェクト
     */
    public PrivateLan withVpnGatewaySets(VpnGateway... vpnGatewaySets) {
        if (this.vpnGatewaySets == null)
            this.vpnGatewaySets = new ArrayList<VpnGateway>();
        for (VpnGateway vpnGatewaySet : vpnGatewaySets) {
            getVpnGatewaySets().add(vpnGatewaySet);
        }
        return this;
    }

    /**
     * プライベートLANに接続しているVPNゲートウェイ情報リストを設定し、自オブジェクトを返します。
     *
     * @param vpnGatewaySets
     *            プライベートLANに接続しているVPNゲートウェイ情報リスト
     * @return 自オブジェクト
     */
    public PrivateLan withVpnGatewaySets(Collection<VpnGateway> vpnGatewaySets) {
        if (this.vpnGatewaySets == null)
            this.vpnGatewaySets = new ArrayList<VpnGateway>();
        if (vpnGatewaySets != null) {
            getVpnGatewaySets().addAll(vpnGatewaySets);
        }
        return this;
    }

    /**
     * マルチロードバランサーの情報リストを取得します。
     * 
     * @return マルチロードバランサーの情報リスト
     */
    public List<ElasticLoadBalancing> getElasticLoadBalancingSets() {
        return elasticLoadBalancingSets;
    }

    /**
     * マルチロードバランサーの情報リストを設定します。
     * 
     * @param elasticLoadBalancingSets
     *            マルチロードバランサーの情報リスト
     */
    public void setElasticLoadBalancingSets(List<ElasticLoadBalancing> elasticLoadBalancingSets) {
        this.elasticLoadBalancingSets = elasticLoadBalancingSets;
    }

    /**
     * マルチロードバランサー情報の配列を設定し、自オブジェクトを返します。
     *
     * @param elasticLoadBalancingSets
     *            マルチロードバランサー情報
     * @return 自オブジェクト
     */
    public PrivateLan
        withElasticLoadBalancingSets(ElasticLoadBalancing... elasticLoadBalancingSets) {
        if (this.elasticLoadBalancingSets == null)
            this.elasticLoadBalancingSets = new ArrayList<ElasticLoadBalancing>();
        for (ElasticLoadBalancing elasticLoadBalancingSet : elasticLoadBalancingSets) {
            getElasticLoadBalancingSets().add(elasticLoadBalancingSet);
        }
        return this;
    }

    /**
     * マルチロードバランサーの情報リストを設定し、自オブジェクトを返します。
     *
     * @param elasticLoadBalancingSets
     *            マルチロードバランサーの情報リスト
     * @return 自オブジェクト
     */
    public PrivateLan
        withElasticLoadBalancingSets(Collection<ElasticLoadBalancing> elasticLoadBalancingSets) {
        if (this.elasticLoadBalancingSets == null)
            this.elasticLoadBalancingSets = new ArrayList<ElasticLoadBalancing>();
        if (elasticLoadBalancingSets != null) {
            getElasticLoadBalancingSets().addAll(elasticLoadBalancingSets);
        }
        return this;
    }

    /**
     * 作成日時を取得します。
     * 
     * @return 作成日時
     */
    public String getCreatedTime() {
        return createdTime;
    }

    /**
     * 作成日時を設定します。
     * 
     * @param createdTime
     *            作成日時
     */
    public void setCreatedTime(String createdTime) {
        this.createdTime = createdTime;
    }

    /**
     * 作成日時を設定し、自オブジェクトを返します。
     *
     * @param createdTime
     *            作成日時
     * @return 自オブジェクト
     */
    public PrivateLan withCreatedTime(String createdTime) {
        setCreatedTime(createdTime);
        return this;
    }

    /**
     * 共有ステータスを取得します。
     * 
     * @return 共有ステータス
     */
    public String getSharingStatus() {
        return sharingStatus;
    }

    /**
     * 共有ステータスを設定します。
     * 
     * @param sharingStatus
     *            共有ステータス
     */
    public void setSharingStatus(String sharingStatus) {
        this.sharingStatus = sharingStatus;
    }

    /**
     * 共有ステータスを設定し、自オブジェクトを返します。
     *
     * @param sharingStatus
     *            共有ステータス
     * @return 自オブジェクト
     */
    public PrivateLan withSharingStatus(String sharingStatus) {
        setSharingStatus(sharingStatus);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[networkId=");
        builder.append(networkId);
        builder.append(", privateLanName=");
        builder.append(privateLanName);
        builder.append(", state=");
        builder.append(state);
        builder.append(", cidrBlock=");
        builder.append(cidrBlock);
        builder.append(", availabilityZone=");
        builder.append(availabilityZone);
        builder.append(", accountingType=");
        builder.append(accountingType);
        builder.append(", nextMonthAccountingType=");
        builder.append(nextMonthAccountingType);
        builder.append(", description=");
        builder.append(description);
        builder.append(", createdTime=");
        builder.append(createdTime);
        builder.append(", sharingStatus=");
        builder.append(sharingStatus);
        builder.append(", networkInterfaceSets=");
        builder.append(networkInterfaceSets);
        builder.append(", elasticLoadBalancingSets=");
        builder.append(elasticLoadBalancingSets);
        builder.append("]");
        return builder.toString();
    }
}
