/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.privatelan.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftyModifyPrivateLanAttributeリクエストクラス。<br />
 * このクラスはNiftyModifyPrivateLanAttributeへのリクエストを構築します。
 */
@Action("NiftyModifyPrivateLanAttribute")
public class NiftyModifyPrivateLanAttributeRequest implements Request{

	/** ネットワークユニークID */
	private String networkId;

	/** プライベートLAN名 */
	private String privateLanName;

	/** 更新対象の項目名 */
	private String attribute;

	/** 更新値 */
	private String value;

	/**
	 * ネットワークユニークIDを取得します。
	 *
	 * @return ネットワークユニークID
	 */
	@Query(name="NetworkId")
	public String getNetworkId() {
		return networkId;
	}
	/**
	 * ネットワークユニークIDを設定します。
	 *
	 * @param networkId ネットワークユニークID
	 */
	public void setNetworkId(String networkId) {
		this.networkId = networkId;
	}
	/**
	 * ネットワークユニークIDを設定し、自オブジェクトを返します。
	 *
	 * @param networkId ネットワークユニークID
	 * @return 自オブジェクト
	 */
	public NiftyModifyPrivateLanAttributeRequest withNetworkId(String networkId) {
		setNetworkId(networkId);
		return this;
	}

	/**
	 * プライベートLAN名を取得します。
	 *
	 * @return プライベートLAN名
	 */
	@Query(name="PrivateLanName")
	public String getPrivateLanName() {
		return privateLanName;
	}
	/**
	 * プライベートLAN名を設定します。
	 *
	 * @param privateLanName プライベートLAN
	 */
	public void setPrivateLanName(String privateLanName) {
		this.privateLanName = privateLanName;
	}
	/**
	 * プライベートLAN名を設定し、自オブジェクトを返します。
	 *
	 * @param privateLanName プライベートLAN名
	 * @return 自オブジェクト
	 */
	public NiftyModifyPrivateLanAttributeRequest withPrivateLanName(String privateLanName) {
		setPrivateLanName(privateLanName);
		return this;
	}

	/**
	 * 更新対象の項目名を取得します。
	 *
	 * @return 更新対象の項目名
	 */
	@Query(name="Attribute",require=true)
	public String getAttribute() {
		return attribute;
	}
	/**
	 * 更新対象の項目名を設定します。
	 *
	 * @param attribute 更新対象の項目名
	 */
	public void setAttribute(String attribute) {
		this.attribute = attribute;
	}
	/**
	 * 更新対象の項目名を設定し、自オブジェクトを返します。
	 *
	 * @param attribute 更新対象の項目名
	 * @return 自オブジェクト
	 */
	public NiftyModifyPrivateLanAttributeRequest withAttribute(String attribute) {
		setAttribute(attribute);
		return this;
	}

	/**
	 * 更新値を取得します。
	 *
	 * @return 更新値
	 */
	@Query(name="Value",require=true)
	public String getValue() {
		return value;
	}
	/**
	 * 更新値を設定します。
	 *
	 * @param value 更新値
	 */
	public void setValue(String value) {
		this.value = value;
	}
	/**
	 * 更新値を設定し、自オブジェクトを返します。
	 *
	 * @param value 更新値
	 * @return 自オブジェクト
	 */
	public NiftyModifyPrivateLanAttributeRequest withValue(String value) {
		setValue(value);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[networkId=");
		builder.append(networkId);
		builder.append(", privateLanName=");
		builder.append(privateLanName);
		builder.append(", attribute=");
		builder.append(attribute);
		builder.append(", value=");
		builder.append(value);
		builder.append("]");
		return builder.toString();
	}
}
