/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.privatelan.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.Result;
import com.nifty.cloud.sdk.privatelan.model.transform.PrivateLanSetConverter;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;

/**
 * NiftyDescribePrivateLans処理結果クラス。<br />
 * このクラスはNiftyDescribePrivateLansのレスポンスを格納します。
 */
@XStreamAlias("NiftyDescribePrivateLansResponse")
@XStreamConverter(PrivateLanSetConverter.class)
public class NiftyDescribePrivateLansResult extends Result{

	/** リクエスト識別子 */
	@XStreamAlias("requestId")
	private String requestId;

	/** プライベートLAN情報リスト */
	@XStreamAlias("privateLanSet")
	private List<PrivateLan> privateLans;

	/**
	 * リクエスト識別子を取得します。
	 *
	 * @return リクエスト識別子
	 */
	public String getRequestId() {
		return requestId;
	}
	/**
	 * リクエスト識別子を設定します。
	 *
	 * @param requestId リクエスト識別子
	 */
	public void setRequestId(String requestId) {
		this.requestId = requestId;
	}
	/**
	 * リクエスト識別子を設定し、自オブジェクトを返します。
	 *
	 * @param requestId リクエスト識別子
	 * @return 自オブジェクト
	 */
	public NiftyDescribePrivateLansResult withRequestId(String requestId) {
		setRequestId(requestId);
		return this;
	}

	/**
	 * プライベートLAN情報リストを取得します。
	 *
	 * @return プライベートLAN情報リスト
	 */
	public List<PrivateLan> getPrivateLans() {
		return privateLans;
	}
	/**
	 * プライベートLAN情報リストを設定します。
	 *
	 * @param privateLan プライベートLAN情報リスト
	 */
	public void setPrivateLans(List<PrivateLan> privateLans) {
		this.privateLans = privateLans;
	}
	/**
	 * プライベートLAN情報の配列を設定し、自オブジェクトを返します。
	 *
	 * @param privateLans プライベートLAN情報の配列
	 * @return 自オブジェクト
	 */
	public NiftyDescribePrivateLansResult withPrivateLans(PrivateLan ... privateLans) {
		if(this.privateLans == null) this.privateLans = new ArrayList<PrivateLan>();
		for(PrivateLan privateLan: privateLans) {
			getPrivateLans().add(privateLan);
		}
		return this;
	}
	/**
	 * プライベートLAN情報リストを設定し、自オブジェクトを返します。
	 *
	 * @param privateLans プライベートLAN情報リスト
	 * @return 自オブジェクト
	 */
	public NiftyDescribePrivateLansResult withPrivateLans(Collection<PrivateLan> privateLans){
		if(this.privateLans == null) this.privateLans = new ArrayList<PrivateLan>();
		if (privateLans!=null) {
			getPrivateLans().addAll(privateLans);
		}
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[requestId=");
		builder.append(requestId);
		builder.append(", privateLans=");
		builder.append(privateLans);
		builder.append("]");
		return builder.toString();
	}
}
