/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.privatelan.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftyDescribePrivateLansリクエストクラス。<br />
 * このクラスはNiftyDescribePrivateLansへのリクエストを構築します。
 */
@Action("NiftyDescribePrivateLans")
public class NiftyDescribePrivateLansRequest implements Request {

	/** ネットワークユニークID */
	private List<String> networkIds;

	/** プライベートLAN名 */
	private List<String> privateLanNames;

	/** 絞り込み条件の項目名 */
	private List<Filter> filters;

	/**
	 * ネットワークユニークIDリストを取得します。
	 *
	 * @return ネットワークユニークIDリスト
	 */
	@Query(name = "NetworkId")
	public List<String> getNetworkIds() {
		return networkIds;
	}

	/**
	 * ネットワークユニークIDリストを設定します。
	 *
	 * @param networkIds ネットワークユニークIDリスト
	 */
	public void setNetworkIds(List<String> networkIds) {
		this.networkIds = networkIds;
	}

	/**
	 * プライベートLAN名リストを取得します。
	 *
	 * @param プライベートLAN名リスト
	 */
	@Query(name = "PrivateLanName")
	public List<String> getPrivateLanNames() {
		return privateLanNames;
	}

	/**
	 * プライベートLAN名リストを設定します。
	 *
	 * @param プライベートLAN名リスト
	 */
	public void setPrivateLanNames(List<String> privateLanNames) {
		this.privateLanNames = privateLanNames;
	}

	/**
	 * ネットワークユニークIDの配列を設定し、自オブジェクトを返します。
	 *
	 * @param networkIds ネットワークユニークIDの配列
	 * @return 自オブジェクト
	 */
	public NiftyDescribePrivateLansRequest withNetworkIds(String ... networkIds) {
		if(this.networkIds == null) this.networkIds = new ArrayList<String>();
		for (String networkId : networkIds) {
			getNetworkIds().add(networkId);
		}
		return this;
	}

	/**
	 * ネットワークユニークIDリストを設定し、自オブジェクトを返します。
	 *
	 * @param networkIds ネットワークユニークIDリスト
	 * @return 自オブジェクト
	 */
	public NiftyDescribePrivateLansRequest withNetworkIds(Collection<String> networkIds) {
		if(this.networkIds == null) this.networkIds = new ArrayList<String>();
		if (networkIds != null) {
			getNetworkIds().addAll(networkIds);
		}
		return this;
	}

	/**
	 * プライベートLAN名の配列を設定し、自オブジェクトを返します。
	 *
	 * @param privateLanNames プライベートLAN名の配列
	 * @return 自オブジェクト
	 */
	public NiftyDescribePrivateLansRequest withPrivateLanNames(String ... privateLanNames) {
		if(this.privateLanNames == null) this.privateLanNames = new ArrayList<String>();
		for (String privateLanName : privateLanNames) {
			getPrivateLanNames().add(privateLanName);
		}
		return this;
	}

	/**
	 * プライベートLAN名リストを設定し、自オブジェクトを返します。
	 *
	 * @param privateLanNames プライベートLAN名リスト
	 * @return 自オブジェクト
	 */
	public NiftyDescribePrivateLansRequest withPrivateLanNames(Collection<String> privateLanNames) {
		if(this.privateLanNames == null) this.privateLanNames = new ArrayList<String>();
		if (privateLanNames != null) {
			getPrivateLanNames().addAll(privateLanNames);
		}
		return this;
	}

	/**
	 * 絞り込み情報リストを取得します。
	 *
	 * @return 絞り込み情報リスト
	 */
	@Query(name = "Filter")
	public List<Filter> getFilters() {
		return filters;
	}

	/**
	 * 絞り込み情報リストを設定します。
	 *
	 * @param filters 絞り込み情報リスト
	 */
	public void setFilters(List<Filter> filters) {
		this.filters = filters;
	}

	/**
	 * 絞り込み情報の配列を設定し、自オブジェクトを返します。
	 *
	 * @param filters 絞り込み情報の配列
	 * @return 自オブジェクト
	 */
	public NiftyDescribePrivateLansRequest withFilters(Filter ... filters) {
		if (this.filters == null) this.filters = new ArrayList<Filter>();
		for (Filter filter : filters) {
			getFilters().add(filter);
		}
		return this;
	}

	/**
	 * 絞り込み情報リストを設定し、自オブジェクトを返します。
	 *
	 * @param filters 絞り込み情報リスト
	 * @return 自オブジェクト
	 */
	public NiftyDescribePrivateLansRequest withFilters(Collection<Filter> filters) {
		if (this.filters == null) this.filters = new ArrayList<Filter>();
		if (filters != null) {
			getFilters().addAll(filters);
		}
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[networkIds=");
		builder.append(networkIds);
		builder.append(", privateLanNames=");
		builder.append(privateLanNames);
		builder.append(", filters=");
		builder.append(filters);
		builder.append("]");
		return builder.toString();
	}
}