/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.privatelan.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftyDeletePrivateLanリクエストクラス。<br />
 * このクラスはNiftyDeletePrivateLanへのリクエストを構築します。
 */
@Action("NiftyDeletePrivateLan")
public class NiftyDeletePrivateLanRequest implements Request{

	/** ネットワークユニークID */
	private String networkId;

	/** プライベートLAN名 */
	private String privateLanName;

	/**
	 * ネットワークユニークIDを取得します。
	 *
	 * @return ネットワークユニークID
	 */
	@Query(name="NetworkId")
	public String getNetworkId() {
		return networkId;
	}
	/**
	 * ネットワークユニークIDを設定します。
	 * @param networkId ネットワークユニークID
	 */
	public void setNetworkId(String networkId) {
		this.networkId = networkId;
	}
	/**
	 * ネットワークユニークIDを設定し、自オブジェクトを返します。
	 *
	 * @param networkId ネットワークユニークID
	 * @return 自オブジェクト
	 */
	public NiftyDeletePrivateLanRequest withNetworkId(String networkId){
		setNetworkId(networkId);
		return this;
	}

	/**
	 * プライベートLAN名を取得します。
	 *
	 * @return プライベートLAN名
	 */
	@Query(name="PrivateLanName")
	public String getPrivateLanName() {
		return privateLanName;
	}
	/**
	 * プライベートLAN名を設定します。
	 * @param privateLanName プライベートLAN名
	 */
	public void setPrivateLanName(String privateLanName) {
		this.privateLanName = privateLanName;
	}
	/**
	 * プライベートLAN名を設定し、自オブジェクトを返します。
	 *
	 * @param privateLanName プライベートLAN名
	 * @return 自オブジェクト
	 */
	public NiftyDeletePrivateLanRequest withPrivateLanName(String privateLanName){
		setPrivateLanName(privateLanName);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[networkId=");
		builder.append(networkId);
		builder.append(", privateLanName=");
		builder.append(privateLanName);
		builder.append("]");
		return builder.toString();
	}
}
