/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.privatelan.model;

import com.nifty.cloud.sdk.Result;
import com.nifty.cloud.sdk.privatelan.model.transform.NiftyCreatePrivateLanResultConverter;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;

/**
 * NiftyCreatePrivateLan処理結果クラス。<br />
 * このクラスはNiftyCreatePrivateLanのレスポンスを格納します。
 */
@XStreamAlias("NiftyCreatePrivateLanResponse")
@XStreamConverter(NiftyCreatePrivateLanResultConverter.class)
public class NiftyCreatePrivateLanResult extends Result{

	/** リクエスト識別子 */
	@XStreamAlias("requestId")
	private String requestId;

	/** プライベートLANの情報 */
	@XStreamAlias("privateLan")
	private PrivateLan privateLan;

	/**
	 * リクエスト識別子を取得します。
	 *
	 * @return リクエスト識別子
	 */
	public String getRequestId() {
		return requestId;
	}
	/**
	 * リクエスト識別子を設定します。
	 *
	 * @param requestId リクエスト識別子
	 */
	public void setRequestId(String requestId) {
		this.requestId = requestId;
	}
	/**
	 * リクエスト識別子を設定し、自オブジェクトを返します。
	 *
	 * @param requestId リクエスト識別子
	 * @return 自オブジェクト
	 */
	public NiftyCreatePrivateLanResult withRequestId(String requestId) {
		setRequestId(requestId);
		return this;
	}

	/**
	 * プライベートLANの情報を取得します。
	 *
	 * @return プライベートLANの情報
	 */
	public PrivateLan getPrivateLan() {
		return privateLan;
	}
	/**
	 * プライベートLANの情報を設定します。
	 *
	 * @param privateLan プライベートLANの情報
	 */
	public void setPrivateLan(PrivateLan privateLan) {
		this.privateLan = privateLan;
	}
	/**
	 * プライベートLANの情報を設定し、自オブジェクトを返します。
	 *
	 * @param privateLan プライベートLANの情報
	 * @return 自オブジェクト
	 */
	public NiftyCreatePrivateLanResult withPrivateLan(PrivateLan privateLan){
		setPrivateLan(privateLan);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[requestId=");
		builder.append(requestId);
		builder.append(", privateLan=");
		builder.append(privateLan);
		builder.append("]");
		return builder.toString();
	}
}
