/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.privatelan.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftyCreatePrivateLanリクエストクラス。<br />
 * このクラスはNiftyCreatePrivateLanへのリクエストを構築します。
 */
@Action("NiftyCreatePrivateLan")
public class NiftyCreatePrivateLanRequest implements Request{

	/** プライベートLAN名 */
	private String privateLanName;

	/** プライベートLANのCIDR */
	private String cidrBlock;

	/** ゾーン情報 */
	private String availabilityZone;

	/** 利用料金タイプ */
	private String accountingType;

	/** プライベートLANのメモ */
	private String description;

	/**
	 * プライベートLAN名を取得します。
	 *
	 * @return プライベートLAN名
	 */
	@Query(name="PrivateLanName")
	public String getPrivateLanName() {
		return privateLanName;
	}
	/**
	 * プライベートLAN名を設定します。
	 * @param privateLanName プライベートLAN名
	 */
	public void setPrivateLanName(String privateLanName) {
		this.privateLanName = privateLanName;
	}
	/**
	 * プライベートLAN名を設定し、自オブジェクトを返します。
	 *
	 * @param privateLanName プライベートLAN名
	 * @return 自オブジェクト
	 */
	public NiftyCreatePrivateLanRequest withPrivateLanName(String privateLanName){
		setPrivateLanName(privateLanName);
		return this;
	}

	/**
	 * プライベートLANのCIDRを取得します。
	 *
	 * @return プライベートLANのCIDR
	 */
	@Query(name="CidrBlock",require=true)
	public String getCidrBlock() {
		return cidrBlock;
	}
	/**
	 * プライベートLANのCIDRを設定します。
	 * @param cidrBlock プライベートLANのCIDR
	 */
	public void setCidrBlock(String cidrBlock) {
		this.cidrBlock = cidrBlock;
	}
	/**
	 * プライベートLANのCIDRを設定し、自オブジェクトを返します。
	 *
	 * @param cidrBlock プライベートLANのCIDR
	 * @return 自オブジェクト
	 */
	public NiftyCreatePrivateLanRequest withCidrBlock(String cidrBlock) {
		setCidrBlock(cidrBlock);
		return this;
	}

	/**
	 * ゾーン情報を取得します。
	 *
	 * @return ゾーン情報
	 */
	@Query(name="AvailabilityZone")
	public String getAvailabilityZone() {
		return availabilityZone;
	}
	/**
	 * ゾーン情報を設定します。
	 * @param availabilityZone ゾーン情報
	 */
	public void setAvailabilityZone(String availabilityZone) {
		this.availabilityZone = availabilityZone;
	}
	/**
	 * ゾーン情報を設定し、自オブジェクトを返します。
	 *
	 * @param availabilityZone ゾーン情報
	 * @return 自オブジェクト
	 */
	public NiftyCreatePrivateLanRequest withAvailabilityZone(String availabilityZone){
		setAvailabilityZone(availabilityZone);
		return this;
	}

	/**
	 * 利用料金タイプを取得します。
	 *
	 * @return 利用料金タイプ
	 */
	@Query(name="AccountingType")
	public String getAccountingType() {
		return accountingType;
	}
	/**
	 * 利用料金タイプを設定します。
	 * @param accountingType 利用料金タイプ
	 */
	public void setAccountingType(String accountingType) {
		this.accountingType = accountingType;
	}
	/**
	 * 利用料金タイプを設定し、自オブジェクトを返します。
	 *
	 * @param accountingType 利用料金タイプ
	 * @return 自オブジェクト
	 */
	public NiftyCreatePrivateLanRequest withAccountingType(String accountingType){
		setAccountingType(accountingType);
		return this;
	}

	/**
	 * プライベートLANのメモを取得します。
	 *
	 * @return プライベートLANのメモ
	 */
	@Query(name="Description")
	public String getDescription() {
		return description;
	}
	/**
	 * プライベートLANのメモを設定します。
	 * @param description プライベートLANのメモ
	 */
	public void setDescription(String description) {
		this.description = description;
	}
	/**
	 * プライベートLANのメモを設定し、自オブジェクトを返します。
	 *
	 * @param description プライベートLANのメモ
	 * @return 自オブジェクト
	 */
	public NiftyCreatePrivateLanRequest withDescription(String description){
		setDescription(description);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[privateLanName=");
		builder.append(privateLanName);
		builder.append(", cidrBlock=");
		builder.append(cidrBlock);
		builder.append(", availabilityZone=");
		builder.append(availabilityZone);
		builder.append(", accountingType=");
		builder.append(accountingType);
		builder.append(", description=");
		builder.append(description);
		builder.append("]");
		return builder.toString();
	}
}
