/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.privatelan.model;

/**
 * ネットワークインターフェースの情報クラス。<br />
 * このクラスはネットワークインターフェースの情報を格納します。
 */
public class NetworkInterface {

    /** ネットワークインターフェースID */
    private String networkInterfaceId;

    /** IPアドレス */
    private String ipAddress;

    /**
     * ネットワークインターフェースIDを取得します。
     *
     * @return ネットワークインターフェースID
     */
    public String getNetworkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * ネットワークインターフェースIDを設定します。
     *
     * @param networkInterfaceId
     *            ネットワークインターフェースID
     */
    public void setNetworkInterfaceId(String networkInterfaceId) {
        this.networkInterfaceId = networkInterfaceId;
    }

    /**
     * ネットワークインターフェースIDを設定し、自オブジェクトを返します。
     *
     * @param networkInterfaceId
     *            ネットワークインターフェースID
     * @return 自オブジェクト
     */
    public NetworkInterface withNetworkInterfaceId(String networkInterfaceId) {
        setNetworkInterfaceId(networkInterfaceId);
        return this;
    }

    /**
     * IPアドレスを取得します。
     *
     * @return IPアドレス
     */
    public String getIpAddress() {
        return ipAddress;
    }

    /**
     * IPアドレスを設定します。
     *
     * @param ipAddress
     *            IPアドレス
     */
    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    /**
     * IPアドレスを設定し、自オブジェクトを返します。
     *
     * @param ipAddress
     *            IPアドレス
     * @return 自オブジェクト
     */
    public NetworkInterface withIpAddress(String ipAddress) {
        setIpAddress(ipAddress);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[networkInterfaceId=");
        builder.append(networkInterfaceId);
        builder.append(", ipAddress=");
        builder.append(ipAddress);
        builder.append("]");
        return builder.toString();
    }
}
