/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.privatelan.model;

/**
 * プライベートLANに接続しているサーバー情報情報クラス。<br />
 * このクラスはプライベートLANに接続しているサーバー情報を格納します。
 */
public class Instance {

	/** サーバーユニークID */
	private String instanceUniqueId;

	/** サーバー名 */
	private String instanceId;

	/** デバイス番号 */
	private Integer deviceIndex;

	/** IPアドレス */
	private String ipAddress;

	/**
	 * サーバーユニークIDを取得します。
	 * @return サーバーユニークID
	 */
	public String getInstanceUniqueId() {
	    return instanceUniqueId;
	}
	/**
	 * サーバーユニークIDを設定します。
	 * @param instanceUniqueId サーバーユニークID
	 */
	public void setInstanceUniqueId(String instanceUniqueId) {
	    this.instanceUniqueId = instanceUniqueId;
	}
	/**
	 * サーバーユニークIDを設定し、自オブジェクトを返します。
	 *
	 * @param instanceUniqueId サーバーユニークID
	 * @return 自オブジェクト
	 */
	public Instance withInstanceUniqueId(String instanceUniqueId) {
		setInstanceUniqueId(instanceUniqueId);
		return this;
	}

	/**
	 * サーバー名を取得します。
	 * @return サーバー名
	 */
	public String getInstanceId() {
	    return instanceId;
	}
	/**
	 * サーバー名を設定します。
	 * @param instanceId サーバー名
	 */
	public void setInstanceId(String instanceId) {
	    this.instanceId = instanceId;
	}
	/**
	 * サーバー名を設定し、自オブジェクトを返します。
	 *
	 * @param instanceId サーバー名
	 * @return 自オブジェクト
	 */
	public Instance withInstanceId(String instanceId) {
		setInstanceId(instanceId);
		return this;
	}

	/**
	 * デバイス番号を取得します。
	 * @return デバイス番号
	 */
	public Integer getDeviceIndex() {
	    return deviceIndex;
	}
	/**
	 * デバイス番号を設定します。
	 * @param deviceIndex デバイス番号
	 */
	public void setDeviceIndex(Integer deviceIndex) {
	    this.deviceIndex = deviceIndex;
	}
	/**
	 * デバイス番号を設定し、自オブジェクトを返します。
	 *
	 * @param instanceId デバイス番号
	 * @return 自オブジェクト
	 */
	public Instance withDeviceIndex(Integer deviceIndex) {
		setDeviceIndex(deviceIndex);
		return this;
	}

	/**
	 * IPアドレスを取得します。
	 * @return IPアドレス
	 */
	public String getIpAddress() {
	    return ipAddress;
	}

	/**
	 * IPアドレスを設定します。
	 * @param ipAddress IPアドレス
	 */
	public void setIpAddress(String ipAddress) {
	    this.ipAddress = ipAddress;
	}
	/**
	 * デバイス番号を設定し、自オブジェクトを返します。
	 *
	 * @param instanceId デバイス番号
	 * @return 自オブジェクト
	 */
	public Instance withIpAddress(String ipAddress) {
		setIpAddress(ipAddress);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[instanceUniqueId=");
		builder.append(instanceUniqueId);
		builder.append(", instanceId=");
		builder.append(instanceId);
		builder.append(", deviceIndex=");
		builder.append(deviceIndex);
		builder.append(", ipAddress=");
		builder.append(ipAddress);
		builder.append("]");
		return builder.toString();
	}
}
