/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.privatelan;

import com.nifty.cloud.sdk.BaseClient;
import com.nifty.cloud.sdk.ClientConfiguration;
import com.nifty.cloud.sdk.auth.Credentials;
import com.nifty.cloud.sdk.privatelan.model.NiftyCreatePrivateLanRequest;
import com.nifty.cloud.sdk.privatelan.model.NiftyCreatePrivateLanResult;
import com.nifty.cloud.sdk.privatelan.model.NiftyDeletePrivateLanRequest;
import com.nifty.cloud.sdk.privatelan.model.NiftyDeletePrivateLanResult;
import com.nifty.cloud.sdk.privatelan.model.NiftyDescribePrivateLansRequest;
import com.nifty.cloud.sdk.privatelan.model.NiftyDescribePrivateLansResult;
import com.nifty.cloud.sdk.privatelan.model.NiftyModifyPrivateLanAttributeRequest;
import com.nifty.cloud.sdk.privatelan.model.NiftyModifyPrivateLanAttributeResult;

/**
 * NIFCLOUD API クライアント　具象クラス。
 * プライベートLANカテゴリ クライアント。<br />
 * プライベートLANカテゴリの同期クライアントの具象クラスです。<br />
 * 戻り値の"利用不可"パラメータは返却値がnullまたは空となります。
 */
public class NiftyPrivateLanClient extends BaseClient implements NiftyPrivateLan {

	/**
	 * 認証情報を指定し、プライベートLANカテゴリクライアントを構築します。
	 *
	 * @param credential 認証情報
	 */
	public NiftyPrivateLanClient(Credentials credential) {
		super(credential, new ClientConfiguration());
	}

	/**
	 * 認証情報、クライアント設定を指定し、プライベートLANカテゴリクライアントを構築します。
	 *
	 * @param credential 認証情報
	 * @param configuration クライアント設定
	 */
	public NiftyPrivateLanClient(Credentials credential, ClientConfiguration configuration) {
		super(credential, configuration);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.privatelan.NiftyPrivateLan#niftyCreatePrivateLan(com.nifty.cloud.sdk.privatelan.model.NiftyCreatePrivateLanRequest)
	 */
	@Override
	public NiftyCreatePrivateLanResult niftyCreatePrivateLan(NiftyCreatePrivateLanRequest request) {
		return (NiftyCreatePrivateLanResult)client.execute(request, NiftyCreatePrivateLanResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.privatelan.NiftyPrivateLan#niftyDeletePrivateLan(com.nifty.cloud.sdk.privatelan.model.NiftyDeletePrivateLanRequest)
	 */
	@Override
	public NiftyDeletePrivateLanResult niftyDeletePrivateLan(NiftyDeletePrivateLanRequest request) {
		return (NiftyDeletePrivateLanResult)client.execute(request, NiftyDeletePrivateLanResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.privatelan.NiftyPrivateLan#niftyModifyPrivateLanAttribute(com.nifty.cloud.sdk.privatelan.model.NiftyModifyPrivateLanAttributeRequest)
	 */
	@Override
	public NiftyModifyPrivateLanAttributeResult niftyModifyPrivateLanAttribute(NiftyModifyPrivateLanAttributeRequest request) {
		return (NiftyModifyPrivateLanAttributeResult)client.execute(request, NiftyModifyPrivateLanAttributeResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.privatelan.NiftyPrivateLan#niftyDescribePrivateLans(com.nifty.cloud.sdk.privatelan.model.NiftyDescribePrivateLansRequest)
	 */
	@Override
	public NiftyDescribePrivateLansResult niftyDescribePrivateLans(NiftyDescribePrivateLansRequest request) {
		return (NiftyDescribePrivateLansResult)client.execute(request, NiftyDescribePrivateLansResult.class);
	}
}
