/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.privatelan;

import java.util.concurrent.Future;

import com.nifty.cloud.sdk.privatelan.model.NiftyCreatePrivateLanRequest;
import com.nifty.cloud.sdk.privatelan.model.NiftyCreatePrivateLanResult;
import com.nifty.cloud.sdk.privatelan.model.NiftyDeletePrivateLanRequest;
import com.nifty.cloud.sdk.privatelan.model.NiftyDeletePrivateLanResult;
import com.nifty.cloud.sdk.privatelan.model.NiftyDescribePrivateLansRequest;
import com.nifty.cloud.sdk.privatelan.model.NiftyDescribePrivateLansResult;
import com.nifty.cloud.sdk.privatelan.model.NiftyModifyPrivateLanAttributeRequest;
import com.nifty.cloud.sdk.privatelan.model.NiftyModifyPrivateLanAttributeResult;

/**
 * NIFCLOUD API 非同期クライアント　インタフェース。
 * プライベートLANカテゴリクライアント。<br />
 * プライベートLANカテゴリの非同期クライアントのインタフェースです。<br />
 * 戻り値の"利用不可"パラメータは返却値がnullまたは空となります。
 */
public interface NiftyPrivateLanAsync extends NiftyPrivateLan {

	/**
	 * 非同期でプライベートLANを新規作成します。
	 *
	 * @param request NiftyCreatePrivateLanリクエスト
	 * @return 非同期処理結果
	 */

	public Future<NiftyCreatePrivateLanResult> niftyCreatePrivateLanAsync(NiftyCreatePrivateLanRequest request);

	/**
	 * 非同期で指定したプライベートLANを削除します。
	 *
	 * @param request NiftyDeletePrivateLanリクエスト
	 * @return 非同期処理結果
	 */

	public Future<NiftyDeletePrivateLanResult> niftyDeletePrivateLanAsync(NiftyDeletePrivateLanRequest request);

	/**
	 * 非同期で指定したプライベートLANの詳細情報を取得します。
	 *
	 * @param request NiftyDescribePrivateLansリクエスト
	 * @return 非同期処理結果
	 */

	public Future<NiftyDescribePrivateLansResult> niftyDescribePrivateLansAsync(NiftyDescribePrivateLansRequest request);

	/**
	 * 非同期で指定したプライベートLANの詳細情報を更新します。
	 *
	 * @param request NiftyModifyPrivateLanAttributeリクエスト
	 * @return 非同期処理結果
	 */

	public Future<NiftyModifyPrivateLanAttributeResult> niftyModifyPrivateLanAttributeAsync(NiftyModifyPrivateLanAttributeRequest request);

}
