/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.privatelan;

import com.nifty.cloud.sdk.privatelan.model.NiftyCreatePrivateLanRequest;
import com.nifty.cloud.sdk.privatelan.model.NiftyCreatePrivateLanResult;
import com.nifty.cloud.sdk.privatelan.model.NiftyDeletePrivateLanRequest;
import com.nifty.cloud.sdk.privatelan.model.NiftyDeletePrivateLanResult;
import com.nifty.cloud.sdk.privatelan.model.NiftyDescribePrivateLansRequest;
import com.nifty.cloud.sdk.privatelan.model.NiftyDescribePrivateLansResult;
import com.nifty.cloud.sdk.privatelan.model.NiftyModifyPrivateLanAttributeRequest;
import com.nifty.cloud.sdk.privatelan.model.NiftyModifyPrivateLanAttributeResult;

/**
 * NIFCLOUD API クライアント　インタフェース。
 * プライベートLANカテゴリ クライアント。<br />
 * プライベートLANカテゴリの同期クライアントのインタフェースです。<br />
 * 戻り値の"利用不可"パラメータは返却値がnullまたは空となります。
 */
public interface NiftyPrivateLan {
	/**
	 * エンドポイントの設定を行います。
	 *
	 * @param endpoint エンドポイント
	 */
	public void setEndpoint(String endpoint);

	/**
	 * プライベートLANを作成します。
	 *
	 * @param request NiftyCreatePrivateLanリクエスト
	 * @return NiftyCreatePrivateLan処理結果
	 */
	public NiftyCreatePrivateLanResult niftyCreatePrivateLan(NiftyCreatePrivateLanRequest request);

	/**
	 * 指定したプライベートLANを削除します。
	 *
	 * @param request NiftyDeletePrivateLanリクエスト
	 * @return NiftyDeletePrivateLan処理結果
	 */
	public NiftyDeletePrivateLanResult niftyDeletePrivateLan(NiftyDeletePrivateLanRequest request);

	/**
	 * 指定したプライベートLANの詳細情報を取得します。
	 *
	 * @param request NiftyDescribePrivateLansリクエスト
	 * @return NiftyDescribePrivateLans処理結果
	 */
	public NiftyDescribePrivateLansResult niftyDescribePrivateLans(NiftyDescribePrivateLansRequest request);

	/**
	 * 指定したプライベートLANの詳細情報を更新します。
	 *
	 * @param request NiftyModifyPrivateLanAttributeリクエスト
	 * @return NiftyModifyPrivateLanAttribute処理結果
	 */
	public NiftyModifyPrivateLanAttributeResult niftyModifyPrivateLanAttribute(NiftyModifyPrivateLanAttributeRequest request);

}
