/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.nic.model.transform;

import java.util.ArrayList;
import java.util.List;

import com.nifty.cloud.sdk.nic.model.Association;
import com.nifty.cloud.sdk.nic.model.PrivateIpAddressesSet;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

/**
 * PrivateIpAddressesSet変換クラス。<br />
 * このクラスはレスポンスXMLのPrivateIpAddressesSetType要素からPrivateIpAddressesSetクラスのリストを生成します。
 *
 */
public class PrivateIpAddressesSetConvert implements Converter {

    private static final String ELEMENT_ASSOCIATION = "association";
    private static final String ELEMENT_PRIMARY = "primary";
    private static final String ELEMENT_PRIVATE_DNS_NAME = "privateDnsName";
    private static final String ELEMENT_PRIVATE_IP_ADDRESS = "privateIpAddress";

    /**
     * 変換可能なクラスか判定します。
     *
     * @param clazz
     *            クラス
     * @return 変換可能な場合true, 変換不可能な場合false
     *
     * @see com.thoughtworks.xstream.converters.Converter#canConvert(Class)
     */
    @SuppressWarnings("rawtypes")
    @Override
    public boolean canConvert(Class clazz) {
        Class[] interfaces = clazz.getInterfaces();
        for (Class i : interfaces) {
            if (i == List.class) {
                return true;
            }
        }
        return false;
    }

    /**
     * {@literal
     * PrivateIpAddressesSetTypeをPrivateIpAddressesSetクラスに変換します。}
     *
     * @param reader
     *            XML読込リーダ
     * @param context
     * @return {@literal PrivateIpAddressesSetオブジェクト}
     *
     * @see com.thoughtworks.xstream.converters.Converter#unmarshal(HierarchicalStreamReader,
     *      UnmarshallingContext)
     */
    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        List<PrivateIpAddressesSet> privateIpAddressesSets = new ArrayList<PrivateIpAddressesSet>();
        String name = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            Converter associationConverter = new AssociationConverter();
            PrivateIpAddressesSet privateIpAddressesSet = new PrivateIpAddressesSet();

            while (reader.hasMoreChildren()) {
                reader.moveDown();
                name = reader.getNodeName();
                if (name.equals(ELEMENT_ASSOCIATION)) {
                    privateIpAddressesSet.setAssociation(
                        (Association) associationConverter.unmarshal(reader, context));
                } else if (name.equals(ELEMENT_PRIMARY)) {
                    privateIpAddressesSet.setPrimary(reader.getValue());
                } else if (name.equals(ELEMENT_PRIVATE_DNS_NAME)) {
                    privateIpAddressesSet.setPrivateDnsName(reader.getValue());
                } else if (name.equals(ELEMENT_PRIVATE_IP_ADDRESS)) {
                    privateIpAddressesSet.setPrivateIpAddress(reader.getValue());
                }
                reader.moveUp();
            }
            privateIpAddressesSets.add(privateIpAddressesSet);
            reader.moveUp();
        }
        return privateIpAddressesSets;
    }

    /**
     * 未実装メソッド
     */
    @Override
    public void marshal(Object paramObject,
        HierarchicalStreamWriter paramHierarchicalStreamWriter,
        MarshallingContext paramMarshallingContext) {
        // 処理無し
    }
}
