/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.nic.model.transform;

import java.util.ArrayList;
import java.util.List;

import com.nifty.cloud.sdk.nic.model.Association;
import com.nifty.cloud.sdk.nic.model.Attachment;
import com.nifty.cloud.sdk.nic.model.NetworkInterfaceSet;
import com.nifty.cloud.sdk.nic.model.PrivateIpAddressesSet;
import com.nifty.cloud.sdk.nic.model.Tag;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

public class NetworkInterfaceSetConverter implements Converter {

    private static final String ELEMENT_ASSOCIATION = "association";
    private static final String ELEMENT_ATTACHMENT = "attachment";
    private static final String ELEMENT_AVAILABILITY_ZONE = "availabilityZone";
    private static final String ELEMENT_DESCRIPTION = "description";
    private static final String ELEMENT_GROUP_SET = "groupSet";
    private static final String ELEMENT_INTERFACE_TYPE = "interfaceType";
    private static final String ELEMENT_IPV6_ADDRESSES_SET = "ipv6AddressesSet";
    private static final String ELEMENT_MAC_ADDRESS = "macAddress";
    private static final String ELEMENT_NETWORK_INTERFACE_ID = "networkInterfaceId";
    private static final String ELEMENT_OWNER_ID = "ownerId";
    private static final String ELEMENT_PRIVATE_DNS_NAME = "privateDnsName";
    private static final String ELEMENT_PRIVATE_IP_ADDRESS = "privateIpAddress";
    private static final String ELEMENT_PRIVATE_IP_ADDRESSES_SET = "privateIpAddressesSet";
    private static final String ELEMENT_REQUESTER_ID = "requesterId";
    private static final String ELEMENT_REQUESTER_MANAGED = "requesterManaged";
    private static final String ELEMENT_SOURCE_DEST_CHECK = "sourceDestCheck";
    private static final String ELEMENT_STATUS = "status";
    private static final String ELEMENT_SUBNET_ID = "subnetId";
    private static final String ELEMENT_TAG_SET = "tagSet";
    private static final String ELEMENT_VPC_ID = "vpcId";
    private static final String ELEMENT_NIFTY_NETWORK_ID = "niftyNetworkId";
    private static final String ELEMENT_NIFTY_NETWORK_NAME = "niftyNetworkName";

    /**
     * 変換可能なクラスか判定します。
     *
     * @param clazz
     *            クラス
     * @return 変換可能な場合true, 変換不可能な場合false
     *
     * @see com.thoughtworks.xstream.converters.Converter#canConvert(Class)
     */
    @SuppressWarnings("rawtypes")
    @Override
    public boolean canConvert(Class clazz) {
        for (Class i : clazz.getInterfaces()) {
            if (i == List.class) {
                return true;
            }
        }
        return false;
    }

    /**
     * {@literal
     * regionInfo要素をList<NetworkInterfaceSet>クラスに変換します。}
     *
     * @param reader
     *            XML読込リーダ
     * @param context
     * @return {@literal List<NetworkInterfaceSet>オブジェクト}
     *
     * @see com.thoughtworks.xstream.converters.Converter#unmarshal(HierarchicalStreamReader,
     *      UnmarshallingContext)
     */
    @SuppressWarnings("unchecked")
    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {

        List<NetworkInterfaceSet> networkInterfaceSets = new ArrayList<NetworkInterfaceSet>();

        Converter associationConverter = new AssociationConverter();
        Converter attachmentConverter = new AttachmentConverter();
        Converter groupSetConverter = new GroupSetConverter();
        Converter ipv6AddressesSetConvert = new Ipv6AddressesSetConvert();
        Converter privateIpAddressesSetConvert = new PrivateIpAddressesSetConvert();
        Converter tagSetConverter = new TagSetConverter();

        String name = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            NetworkInterfaceSet networkInterfaceSet = new NetworkInterfaceSet();

            while (reader.hasMoreChildren()) {
                reader.moveDown();

                name = reader.getNodeName();
                if (name.equals(ELEMENT_ASSOCIATION)) {
                    networkInterfaceSet
                        .setAssociation(
                            (Association) associationConverter.unmarshal(reader, context));
                } else if (name.equals(ELEMENT_ATTACHMENT)) {
                    networkInterfaceSet
                        .setAttachment((Attachment) attachmentConverter.unmarshal(reader, context));
                } else if (name.equals(ELEMENT_AVAILABILITY_ZONE)) {
                    networkInterfaceSet.setAvailabilityZone(reader.getValue());
                } else if (name.equals(ELEMENT_DESCRIPTION)) {
                    networkInterfaceSet.setDescription(reader.getValue());
                } else if (name.equals(ELEMENT_GROUP_SET)) {
                    networkInterfaceSet
                        .setGroupIds((List<String>) groupSetConverter.unmarshal(reader, context));
                } else if (name.equals(ELEMENT_INTERFACE_TYPE)) {
                    networkInterfaceSet.setInterfaceType(reader.getValue());
                } else if (name.equals(ELEMENT_IPV6_ADDRESSES_SET)) {
                    networkInterfaceSet.setIpv6Addresses(
                        (List<String>) ipv6AddressesSetConvert.unmarshal(reader, context));
                } else if (name.equals(ELEMENT_MAC_ADDRESS)) {
                    networkInterfaceSet.setMacAddress(reader.getValue());
                } else if (name.equals(ELEMENT_NETWORK_INTERFACE_ID)) {
                    networkInterfaceSet.setNetworkInterfaceId(reader.getValue());
                } else if (name.equals(ELEMENT_OWNER_ID)) {
                    networkInterfaceSet.setOwnerId(reader.getValue());
                } else if (name.equals(ELEMENT_PRIVATE_DNS_NAME)) {
                    networkInterfaceSet.setPrivateDnsName(reader.getValue());
                } else if (name.equals(ELEMENT_PRIVATE_IP_ADDRESS)) {
                    networkInterfaceSet.setPrivateIpAddress(reader.getValue());
                } else if (name.equals(ELEMENT_PRIVATE_IP_ADDRESSES_SET)) {
                    networkInterfaceSet.setPrivateIpAddressesSet(
                        (List<PrivateIpAddressesSet>) privateIpAddressesSetConvert.unmarshal(reader,
                            context));
                } else if (name.equals(ELEMENT_REQUESTER_ID)) {
                    networkInterfaceSet.setRequesterId(reader.getValue());
                } else if (name.equals(ELEMENT_REQUESTER_MANAGED)) {
                    networkInterfaceSet.setRequesterManaged(reader.getValue());
                } else if (name.equals(ELEMENT_SOURCE_DEST_CHECK)) {
                    networkInterfaceSet.setSourceDestCheck(reader.getValue());
                } else if (name.equals(ELEMENT_STATUS)) {
                    networkInterfaceSet.setStatus(reader.getValue());
                } else if (name.equals(ELEMENT_SUBNET_ID)) {
                    networkInterfaceSet.setSubnetId(reader.getValue());
                } else if (name.equals(ELEMENT_TAG_SET)) {
                    networkInterfaceSet
                        .setTagSets((List<Tag>) tagSetConverter.unmarshal(reader, context));
                } else if (name.equals(ELEMENT_VPC_ID)) {
                    networkInterfaceSet.setVpcId(reader.getValue());
                } else if (name.equals(ELEMENT_NIFTY_NETWORK_ID)) {
                    networkInterfaceSet.setNiftyNetworkId(reader.getValue());
                } else if (name.equals(ELEMENT_NIFTY_NETWORK_NAME)) {
                    networkInterfaceSet.setNiftyNetworkName(reader.getValue());
                }
                reader.moveUp();
            }
            networkInterfaceSets.add(networkInterfaceSet);
            reader.moveUp();
        }

        return networkInterfaceSets;
    }

    /**
     * 未実装メソッド
     */
    @Override
    public void marshal(Object paramObject,
        HierarchicalStreamWriter paramHierarchicalStreamWriter,
        MarshallingContext paramMarshallingContext) {
        // 処理無し
    }
}
