/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.nic.model;

/**
 * プライベートIPアドレス(IPv4)情報セットクラス。<br />
 * このクラスはPrivateIpAddressesSetを格納します。
 */
public class PrivateIpAddressesSet {

    /** プライベートIPアドレス(IPv4)のネットワークインターフェース関連付け情報 */
    private Association association;

    private String primary;

    private String privateDnsName;

    private String privateIpAddress;

    /**
     * プライベートIPアドレス(IPv4)のネットワークインターフェース関連付け情報を取得します。
     * 
     * @return プライベートIPアドレス(IPv4)のネットワークインターフェース関連付け情報
     */
    public Association getAssociation() {
        return association;
    }

    /**
     * プライベートIPアドレス(IPv4)のネットワークインターフェース関連付け情報を設定します。
     *
     * @param association
     *            プライベートIPアドレス(IPv4)のネットワークインターフェース関連付け情報
     */
    public void setAssociation(Association association) {
        this.association = association;
    }

    /**
     * プライベートIPアドレス(IPv4)のネットワークインターフェース関連付け情報を設定し、自オブジェクトを返します。
     *
     * @param association
     *            プライベートIPアドレス(IPv4)のネットワークインターフェース関連付け情報
     * @return 自オブジェクト
     */
    public PrivateIpAddressesSet withAssociation(Association association) {
        setAssociation(association);
        return this;
    }

    /**
     * primaryを取得します。
     * 
     * @return primary
     */
    public String getPrimary() {
        return primary;
    }

    /**
     * primaryを設定します。
     * 
     * @param primary
     */
    public void setPrimary(String primary) {
        this.primary = primary;
    }

    /**
     * primaryを設定し、自オブジェクトを返します。
     *
     * @param primary
     * @return 自オブジェクト
     */
    public PrivateIpAddressesSet withPrimary(String primary) {
        setPrimary(primary);
        return this;
    }

    /**
     * privateDnsNameを取得します。
     *
     * @return privateDnsName
     */
    public String getPrivateDnsName() {
        return privateDnsName;
    }

    /**
     * privateDnsNameを設定します。
     *
     * @param privateDnsName
     * 
     */
    public void setPrivateDnsName(String privateDnsName) {
        this.privateDnsName = privateDnsName;
    }

    /**
     * privateDnsNameを設定し、自オブジェクトを返します。
     *
     * @param privateDnsName
     * 
     * @return 自オブジェクト
     */
    public PrivateIpAddressesSet withPrivateDnsName(String privateDnsName) {
        setPrivateDnsName(privateDnsName);
        return this;
    }

    /**
     * privateIpAddressを取得します。
     * 
     * @return privateIpAddress
     */
    public String getPrivateIpAddress() {
        return privateIpAddress;
    }

    /**
     * privateIpAddressを設定します。
     * 
     * @param privateIpAddress
     */
    public void setPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
    }

    /**
     * privateIpAddressを設定し、自オブジェクトを返します。
     * 
     * @param privateIpAddress
     * @return 自オブジェクト
     */
    public PrivateIpAddressesSet withPrivateIpAddress(String privateIpAddress) {
        setPrivateIpAddress(privateIpAddress);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[association=");
        builder.append(association);
        builder.append(", primary=");
        builder.append(primary);
        builder.append(", privateDnsName=");
        builder.append(privateDnsName);
        builder.append(", privateIpAddress=");
        builder.append(privateIpAddress);
        builder.append("]");
        return builder.toString();
    }
}
