/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.nic.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * ネットワークインターフェースクラス。<br />
 * このクラスはNetworkInterface情報を格納します。
 */
public class NetworkInterface {

    /** 付替IPの関連付け情報 */
    private Association association;

    /** サーバーへの割り当て情報 */
    private Attachment attachment;

    /** ゾーン名 */
    private String availabilityZone;

    /** メモ情報(CDATA付) */
    private String description;

    /** ファイアウォールグループ名リスト */
    private List<String> groupIds;

    /** ネットワークインターフェースタイプ */
    private String interfaceType;

    /** グローバルIPアドレス(IPv6)情報 */
    private List<String> ipv6Addresses;

    /** MACアドレス */
    private String macAddress;

    /** ネットワークインターフェースID */
    private String networkInterfaceId;

    private String ownerId;

    private String privateDnsName;

    /** プライベートIPアドレス */
    private String privateIpAddress;

    /** プライベートIPアドレス(IPv4)情報セット */
    private List<PrivateIpAddressesSet> privateIpAddressesSets;

    private String requesterId;

    private String requesterManaged;

    private String sourceDestCheck;

    /** ネットワークインターフェースのステータス */
    private String status;

    private String subnetId;

    /** リソースに設定されているタグ情報セット */
    private List<Tag> tagSets;

    private String vpcId;

    /** ネットワークユニークID */
    private String niftyNetworkId;

    /** ネットワーク名 */
    private String niftyNetworkName;

    /**
     * 付替IPの関連付け情報を取得します。
     *
     * @return 付替IPの関連付け情報
     */
    public Association getAssociation() {
        return association;
    }

    /**
     * 付替IPの関連付け情報を設定します。
     *
     * @param association
     *            付替IPの関連付け情報
     */
    public void setAssociation(Association association) {
        this.association = association;
    }

    /**
     * 付替IPの関連付け情報を設定し、自オブジェクトを返します。
     *
     * @param association
     *            付替IPの関連付け情報
     * @return 自オブジェクト
     */
    public NetworkInterface withAssociation(Association association) {
        setAssociation(association);
        return this;
    }

    /**
     * サーバーへの割り当て情報を取得します。
     * 
     * @return サーバーへの割り当て情報
     */
    public Attachment getAttachment() {
        return attachment;
    }

    /**
     * サーバーへの割り当て情報を設定します。
     * 
     * @param attachment
     *            サーバーへの割り当て情報
     */
    public void setAttachment(Attachment attachment) {
        this.attachment = attachment;
    }

    /**
     * サーバーへの割り当て情報を設定し、自オブジェクトを返します。
     * 
     * @param attachment
     *            サーバーへの割り当て情報
     * @return 自オブジェクト
     */
    public NetworkInterface withAttachment(Attachment attachment) {
        setAttachment(attachment);
        return this;
    }

    /**
     * ゾーン名を取得します。
     *
     * @return ゾーン名
     */
    public String getAvailabilityZone() {
        return availabilityZone;
    }

    /**
     * ゾーン名を設定します。
     *
     * @param availabilityZone
     *            ゾーン名
     */
    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    /**
     * ゾーン名を設定し、自オブジェクトを返します。
     *
     * @param availabilityZone
     *            ゾーン名
     * @return 自オブジェクト
     */
    public NetworkInterface withAvailabilityZone(String availabilityZone) {
        setAvailabilityZone(availabilityZone);
        return this;
    }

    /**
     * メモを取得します。
     *
     * @return メモ
     */
    public String getDescription() {
        return description;
    }

    /**
     * メモを設定します。
     *
     * @param description
     *            メモ
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * メモを設定し、自オブジェクトを返します。
     *
     * @param description
     *            メモ
     * @return 自オブジェクト
     */
    public NetworkInterface withDescription(String description) {
        setDescription(description);
        return this;
    }

    /**
     * ファイアウォールグループ名リストを取得します。
     *
     * @return ファイアウォールグループ名リスト
     */
    public List<String> getGroupIds() {
        return groupIds;
    }

    /**
     * ファイアウォールグループ名リストを設定します。
     *
     * @param groupIds
     *            ファイアウォールグループ名リスト
     */
    public void setGroupIds(List<String> groupIds) {
        this.groupIds = groupIds;
    }

    /**
     * ファイアウォールグループ名の配列を設定し、自オブジェクトを返します。
     *
     * @param groupIds
     *            ファイアウォールグループ名の配列
     * @return 自オブジェクト
     */
    public NetworkInterface withGroupIds(String... groupIds) {
        if (this.groupIds == null)
            this.groupIds = new ArrayList<String>();
        for (String groupId : groupIds) {
            getGroupIds().add(groupId);
        }
        return this;
    }

    /**
     * ファイアウォールグループ名リストを設定し、自オブジェクトを返します。
     *
     * @param groupIds
     *            ファイアウォールグループ名リスト
     * @return 自オブジェクト
     */
    public NetworkInterface withGroupIds(Collection<String> groupIds) {
        if (this.groupIds == null)
            this.groupIds = new ArrayList<String>();
        if (groupIds != null) {
            getGroupIds().addAll(groupIds);
        }
        return this;
    }

    /**
     * ネットワークインターフェースタイプを取得します。
     * 
     * @return ネットワークインターフェースタイプ
     */
    public String getInterfaceType() {
        return interfaceType;
    }

    /**
     * ネットワークインターフェースタイプを設定します。
     * 
     * @param interfaceType
     *            ネットワークインターフェースタイプ
     */
    public void setInterfaceType(String interfaceType) {
        this.interfaceType = interfaceType;
    }

    /**
     * ネットワークインターフェースタイプを設定し、自オブジェクトを返します。
     *
     * @param interfaceType
     *            ネットワークインターフェースタイプ
     * @return 自オブジェクト
     */
    public NetworkInterface withInterfaceType(String requesterId) {
        setInterfaceType(requesterId);
        return this;
    }

    /**
     * グローバルIPアドレス(IPv6)情報を取得します。
     *
     * @return グローバルIPアドレス(IPv6)情報
     */
    public List<String> getIpv6Addresses() {
        return ipv6Addresses;
    }

    /**
     * グローバルIPアドレス(IPv6)情報を設定します。
     *
     * @param ipv6Addresses
     *            グローバルIPアドレス(IPv6)情報
     * 
     */
    public void setIpv6Addresses(List<String> ipv6Addresses) {
        this.ipv6Addresses = ipv6Addresses;
    }

    /**
     * グローバルIPアドレス(IPv6)情報配列を設定し、自オブジェクトを返します。
     *
     * @param ipv6Addresses
     *            グローバルIPアドレス(IPv6)情報配列
     * @return 自オブジェクト
     */
    public NetworkInterface withIpv6Addresses(String... ipv6Addresses) {
        if (this.ipv6Addresses == null)
            this.ipv6Addresses = new ArrayList<String>();
        for (String ipv6Address : ipv6Addresses) {
            getIpv6Addresses().add(ipv6Address);
        }
        return this;
    }

    /**
     * グローバルIPアドレス(IPv6)情報を設定し、自オブジェクトを返します。
     *
     * @param ipv6Addresses
     *            グローバルIPアドレス(IPv6)情報
     * @return 自オブジェクト
     */
    public NetworkInterface withIpv6Addresses(Collection<String> ipv6Addresses) {
        if (this.ipv6Addresses == null)
            this.ipv6Addresses = new ArrayList<String>();
        if (ipv6Addresses != null) {
            getIpv6Addresses().addAll(ipv6Addresses);
        }
        return this;
    }

    /**
     * MACアドレスを取得します。
     *
     * @return MACアドレス
     */
    public String getMacAddress() {
        return macAddress;
    }

    /**
     * MACアドレスを設定します。
     *
     * @param macAddress
     *            MACアドレス
     */
    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    /**
     * MACアドレスを設定し、自オブジェクトを返します。
     *
     * @param macAddress
     *            MACアドレス
     * @return 自オブジェクト
     */
    public NetworkInterface withMacAddress(String macAddress) {
        setMacAddress(macAddress);
        return this;
    }

    /**
     * ネットワークインターフェースIDを取得します。
     *
     * @return ネットワークインターフェースID
     */
    public String getNetworkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * ネットワークインターフェースIDを設定します。
     *
     * @param networkInterfaceId
     *            ネットワークインターフェースID
     */
    public void setNetworkInterfaceId(String networkInterfaceId) {
        this.networkInterfaceId = networkInterfaceId;
    }

    /**
     * ネットワークインターフェースIDを設定し、自オブジェクトを返します。
     *
     * @param networkInterfaceId
     *            ネットワークインターフェースID
     * @return 自オブジェクト
     */
    public NetworkInterface withNetworkInterfaceId(String networkInterfaceId) {
        setNetworkInterfaceId(networkInterfaceId);
        return this;
    }

    /**
     * ownerIdを取得します。
     * 
     * @return ownerId
     */
    public String getOwnerId() {
        return ownerId;
    }

    /**
     * ownerIdを設定します。
     * 
     * @param ownerId
     */
    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    /**
     * ownerIdを設定し、自オブジェクトを返します。
     * 
     * @param ownerId
     * @return 自オブジェクト
     */
    public NetworkInterface withOwnerId(String ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    /**
     * privateDnsNameを取得します。
     *
     * @return privateDnsName
     */
    public String getPrivateDnsName() {
        return privateDnsName;
    }

    /**
     * privateDnsNameを設定します。
     *
     * @param privateDnsName
     * 
     */
    public void setPrivateDnsName(String privateDnsName) {
        this.privateDnsName = privateDnsName;
    }

    /**
     * privateDnsNameを設定し、自オブジェクトを返します。
     *
     * @param privateIpAddress
     * 
     * @return 自オブジェクト
     */
    public NetworkInterface withPrivateDnsName(String privateDnsName) {
        setPrivateDnsName(privateDnsName);
        return this;
    }

    /**
     * プライベートIPアドレスを取得します。
     * 
     * @return プライベートIPアドレス
     */
    public String getPrivateIpAddress() {
        return privateIpAddress;
    }

    /**
     * プライベートIPアドレスを設定します。
     * 
     * @param privateIpAddress
     *            プライベートIPアドレス
     */
    public void setPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
    }

    /**
     * プライベートIPアドレスを設定し、自オブジェクトを返します。
     *
     * @param privateIpAddress
     *            プライベートIPアドレス
     * @return 自オブジェクト
     */
    public NetworkInterface withPrivateIpAddress(String privateIpAddress) {
        setPrivateIpAddress(privateIpAddress);
        return this;
    }

    /**
     * プライベートIPアドレス(IPv4)情報セットを取得します。
     *
     * @return プライベートIPアドレス(IPv4)情報セット
     */
    public List<PrivateIpAddressesSet> getPrivateIpAddressesSets() {
        return privateIpAddressesSets;
    }

    /**
     * プライベートIPアドレス(IPv4)情報セットを設定します。
     *
     * @param privateIpAddressesSet
     *            プライベートIPアドレス(IPv4)情報セット
     */
    public void setPrivateIpAddressesSet(List<PrivateIpAddressesSet> privateIpAddressesSets) {
        this.privateIpAddressesSets = privateIpAddressesSets;
    }

    /**
     * プライベートIPアドレス(IPv4)情報セット配列を設定し、自オブジェクトを返します。
     *
     * @param privateIpAddressesSet
     *            プライベートIPアドレス(IPv4)情報セット配列
     * @return 自オブジェクト
     */
    public NetworkInterface
        withPrivateIpAddressesSets(PrivateIpAddressesSet... privateIpAddressesSets) {
        if (this.privateIpAddressesSets == null)
            this.privateIpAddressesSets = new ArrayList<PrivateIpAddressesSet>();
        for (PrivateIpAddressesSet privateIpAddressesSet : privateIpAddressesSets) {
            getPrivateIpAddressesSets().add(privateIpAddressesSet);
        }
        return this;
    }

    /**
     * プライベートIPアドレス(IPv4)情報セットを設定し、自オブジェクトを返します。
     *
     * @param privateIpAddressesSet
     *            プライベートIPアドレス(IPv4)情報セット
     * @return 自オブジェクト
     */
    public NetworkInterface
        withPrivateIpAddressesSets(Collection<PrivateIpAddressesSet> privateIpAddressesSets) {
        if (this.privateIpAddressesSets == null)
            this.privateIpAddressesSets = new ArrayList<PrivateIpAddressesSet>();
        if (privateIpAddressesSets != null) {
            getPrivateIpAddressesSets().addAll(privateIpAddressesSets);
        }
        return this;
    }

    /**
     * requesterIdを取得します。
     * 
     * @return requesterId
     */
    public String getRequesterId() {
        return requesterId;
    }

    /**
     * requesterIdを設定します。
     * 
     * @param requesterId
     * 
     */
    public void setRequesterId(String requesterId) {
        this.requesterId = requesterId;
    }

    /**
     * requesterIdを設定し、自オブジェクトを返します。
     *
     * @param requesterId
     * 
     * @return 自オブジェクト
     */
    public NetworkInterface withRequesterId(String requesterId) {
        setRequesterId(requesterId);
        return this;
    }

    /**
     * requesterManagedを取得します。
     * 
     * @return requesterManaged
     */
    public String getRequesterManaged() {
        return requesterManaged;
    }

    /**
     * requesterManagedを設定します。
     * 
     * @param requesterManaged
     */
    public void setRequesterManaged(String requesterManaged) {
        this.requesterManaged = requesterManaged;
    }

    /**
     * requesterManagedを設定し、自オブジェクトを返します。
     *
     * @param requesterManaged
     * @return 自オブジェクト
     */
    public NetworkInterface withRequesterManaged(String requesterManaged) {
        setRequesterManaged(requesterManaged);
        return this;
    }

    /**
     * sourceDestCheckを取得します。
     *
     * @return sourceDestCheck
     */
    public String getSourceDestCheck() {
        return sourceDestCheck;
    }

    /**
     * sourceDestCheckを設定します。
     *
     * @param sourceDestCheck
     * 
     */
    public void setSourceDestCheck(String sourceDestCheck) {
        this.sourceDestCheck = sourceDestCheck;
    }

    /**
     * sourceDestCheckを設定し、自オブジェクトを返します。
     *
     * @param sourceDestCheck
     * 
     * @return 自オブジェクト
     */
    public NetworkInterface withSourceDestCheck(String sourceDestCheck) {
        setSourceDestCheck(sourceDestCheck);
        return this;
    }

    /**
     * 作成ステータスを取得します。
     * 
     * @return 作成ステータス
     */
    public String getStatus() {
        return status;
    }

    /**
     * 作成ステータスを設定します。
     * 
     * @param status
     *            作成ステータス
     */
    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * 作成ステータスを設定し、自オブジェクトを返します。
     * 
     * @param status
     *            作成ステータス
     * @return 自オブジェクト
     */
    public NetworkInterface withStatus(String status) {
        setStatus(status);
        return this;
    }

    /**
     * subnetIdを取得します。
     * 
     * @return subnetId
     */
    public String getSubnetId() {
        return subnetId;
    }

    /**
     * subnetIdを設定します。
     * 
     * @param subnetId
     */
    public void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    /**
     * subnetIdを設定し、自オブジェクトを返します。
     * 
     * @param subnetId
     * @return 自オブジェクト
     */
    public NetworkInterface withSubnetId(String subnetId) {
        setSubnetId(subnetId);
        return this;
    }

    /**
     * リソースに設定されているタグ情報セットを取得します。
     * 
     * @return リソースに設定されているタグ情報セット
     */
    public List<Tag> getTagSets() {
        return tagSets;
    }

    /**
     * リソースに設定されているタグ情報セットを設定します。
     * 
     * @param tagSets
     *            リソースに設定されているタグ情報セット
     */
    public void setTagSets(List<Tag> tagSets) {
        this.tagSets = tagSets;
    }

    /**
     * リソースに設定されているタグ情報セットの配列を設定し、自オブジェクトを返します。
     *
     * @param tagSets
     *            リソースに設定されているタグ情報セットの配列
     * @return 自オブジェクト
     */
    public NetworkInterface withTagSets(Tag... tagSets) {
        if (this.tagSets == null)
            this.tagSets = new ArrayList<Tag>();
        for (Tag tagSet : tagSets) {
            getTagSets().add(tagSet);
        }
        return this;
    }

    /**
     * リソースに設定されているタグ情報セットのリストを設定し、自オブジェクトを返します。
     *
     * @param tagSets
     *            リソースに設定されているタグ情報セット
     * @return 自オブジェクト
     */
    public NetworkInterface withTagSets(Collection<Tag> tagSets) {
        if (this.tagSets == null)
            this.tagSets = new ArrayList<Tag>();
        if (tagSets != null) {
            getTagSets().addAll(tagSets);
        }
        return this;
    }

    /**
     * vpcIdを取得します。
     *
     * @return vpcId
     */
    public String getVpcId() {
        return vpcId;
    }

    /**
     * vpcIdを設定します。
     *
     * @param vpcId
     */
    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    /**
     * vpcIdを設定し、自オブジェクトを返します。
     *
     * @param vpcId
     * @return 自オブジェクト
     */
    public NetworkInterface withVpcId(String vpcId) {
        setVpcId(vpcId);
        return this;
    }

    /**
     * ネットワークユニークIDを取得します。
     *
     * @return ネットワークユニークID
     */
    public String getNiftyNetworkId() {
        return niftyNetworkId;
    }

    /**
     * ネットワークユニークIDを設定します。
     *
     * @param niftyNetworkId
     *            ネットワークユニークID
     */
    public void setNiftyNetworkId(String niftyNetworkId) {
        this.niftyNetworkId = niftyNetworkId;
    }

    /**
     * ネットワークユニークIDを設定し、自オブジェクトを返します。
     *
     * @param niftyNetworkId
     *            ネットワークユニークID
     * @return 自オブジェクト
     */
    public NetworkInterface withNiftyNetworkId(String niftyNetworkId) {
        setNiftyNetworkId(niftyNetworkId);
        return this;
    }

    /**
     * ネットワーク名を取得します。
     *
     * @return ネットワーク名
     */
    public String getNiftyNetworkName() {
        return niftyNetworkName;
    }

    /**
     * ネットワーク名を設定します。
     *
     * @param niftyNetworkName
     *            ネットワーク名
     */
    public void setNiftyNetworkName(String niftyNetworkName) {
        this.niftyNetworkName = niftyNetworkName;
    }

    /**
     * ネットワーク名を設定し、自オブジェクトを返します。
     *
     * @param niftyNetworkName
     *            ネットワーク名
     * @return 自オブジェクト
     */
    public NetworkInterface withNiftyNetworkName(String niftyNetworkName) {
        setNiftyNetworkName(niftyNetworkName);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[association=");
        builder.append(association);
        builder.append(", attachment=");
        builder.append(attachment);
        builder.append(", availabilityZone=");
        builder.append(availabilityZone);
        builder.append(", description=");
        builder.append(description);
        builder.append(", groupIds=");
        builder.append(groupIds);
        builder.append(",interfaceType=");
        builder.append(interfaceType);
        builder.append(", ipv6AddressesSet=");
        builder.append(ipv6Addresses);
        builder.append(", macAddress=");
        builder.append(macAddress);
        builder.append(", networkInterfaceId=");
        builder.append(networkInterfaceId);
        builder.append(", ownerId=");
        builder.append(ownerId);
        builder.append(", privateDnsName=");
        builder.append(privateDnsName);
        builder.append(",privateIpAddress=");
        builder.append(privateIpAddress);
        builder.append(", privateIpAddressesSet=");
        builder.append(privateIpAddressesSets);
        builder.append(", requesterId=");
        builder.append(requesterId);
        builder.append(", requesterManaged=");
        builder.append(requesterManaged);
        builder.append(", sourceDestCheck=");
        builder.append(sourceDestCheck);
        builder.append(", status=");
        builder.append(status);
        builder.append(", subnetId=");
        builder.append(subnetId);
        builder.append(",tagSets=");
        builder.append(tagSets);
        builder.append(", vpcId=");
        builder.append(vpcId);
        builder.append(", niftyNetworkId=");
        builder.append(niftyNetworkId);
        builder.append(", niftyNetworkName=");
        builder.append(niftyNetworkName);
        builder.append("]");
        return builder.toString();
    }
}
