/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.nic.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * ModifyNetworkInterfaceAttributeリクエストクラス。<br />
 * このクラスはModifyNetworkInterfaceAttributeへのリクエストを構築します。
 */
@Action("ModifyNetworkInterfaceAttribute")
public class ModifyNetworkInterfaceAttributeRequest implements Request {

    /** ネットワークインターフェースID */
    private String networkInterfaceId;

    /** IPアドレス */
    private String ipAddress;

    /** メモ情報 */
    private String description;

    /**
     * デフォルトコンストラクタ。
     */
    public ModifyNetworkInterfaceAttributeRequest() {

    }

    /**
     * ネットワークインターフェースIDを指定し、ModifyNetworkInterfaceAttributeRequestを構築します。
     * 
     * @param networkInterfaceId
     *            ネットワークインターフェースID
     */
    public ModifyNetworkInterfaceAttributeRequest(String networkInterfaceId) {
        this.networkInterfaceId = networkInterfaceId;
    }

    /**
     * ネットワークインターフェースIDを取得します。
     *
     * @return ネットワークインターフェースID
     */
    @Query(name = "NetworkInterfaceId", require = true)
    public String getNetworkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * ネットワークインターフェースIDを設定します。
     *
     * @param networkInterfaceId
     *            ネットワークインターフェースID
     */
    public void setNetworkInterfaceId(String networkInterfaceId) {
        this.networkInterfaceId = networkInterfaceId;
    }

    /**
     * ネットワークインターフェースIDを設定し、自オブジェクトを返します。
     *
     * @param networkInterfaceId
     *            ネットワークインターフェースID
     * @return 自オブジェクト
     */
    public ModifyNetworkInterfaceAttributeRequest
        withNetworkInterfaceId(String networkInterfaceId) {
        setNetworkInterfaceId(networkInterfaceId);
        return this;
    }

    /**
     * IPアドレスを取得します。
     *
     * @return IPアドレス
     */
    @Query(name = "IpAddress")
    public String getIpAddress() {
        return ipAddress;
    }

    /**
     * IPアドレスを設定します。
     *
     * @param ipAddress
     *            IPアドレス
     */
    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    /**
     * IPアドレスを設定し、自オブジェクトを返します。
     *
     * @param ipAddress
     *            IPアドレス
     * @return 自オブジェクト
     */
    public ModifyNetworkInterfaceAttributeRequest withIpAddress(String ipAddress) {
        setIpAddress(ipAddress);
        return this;
    }

    /**
     * メモ情報を取得します。
     *
     * @return メモ情報
     */
    @Query(name = "Description")
    public String getDescription() {
        return description;
    }

    /**
     * メモ情報を設定します。
     *
     * @param description
     *            メモ情報
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * メモ情報を設定し、自オブジェクトを返します。
     *
     * @param description
     *            メモ情報
     * @return 自オブジェクト
     */
    public ModifyNetworkInterfaceAttributeRequest withDescription(String description) {
        setDescription(description);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[networkInterfaceId=");
        builder.append(networkInterfaceId);
        builder.append(", ipAddress=");
        builder.append(ipAddress);
        builder.append(", description=");
        builder.append(description);
        builder.append("]");
        return builder.toString();
    }
}
