/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.nic.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * DetachNetworkInterfaceリクエストクラス。<br />
 * このクラスはDetachNetworkInterfaceへのリクエストを構築します。
 *
 */
@Action("DetachNetworkInterface")
public class DetachNetworkInterfaceRequest implements Request {

    /** アタッチメントID */
    private String attachmentId;

    /** 再起動オプション */
    private String niftyReboot;

    /**
     * デフォルトコンストラクタ。
     */
    public DetachNetworkInterfaceRequest() {

    }

    /**
     * アタッチメントIDを指定し、DetachNetworkInterfaceRequestを構築します。
     * 
     * @param attachmentId
     *            アタッチメントID
     */
    public DetachNetworkInterfaceRequest(String attachmentId) {
        this.attachmentId = attachmentId;
    }

    /**
     * アタッチメントIDを取得します。
     *
     * @return アタッチメントID
     */
    @Query(name = "AttachmentId", require = true)
    public String getAttachmentId() {
        return attachmentId;
    }

    /**
     * アタッチメントIDを設定します。
     *
     * @param attachmentId
     *            アタッチメントID
     */
    public void setAttachmentId(String attachmentId) {
        this.attachmentId = attachmentId;
    }

    /**
     * アタッチメントIDを設定し、自オブジェクトを返します。
     *
     * @param attachmentId
     *            アタッチメントID
     * @return 自オブジェクト
     */
    public DetachNetworkInterfaceRequest withAttachmentId(String attachmentId) {
        setAttachmentId(attachmentId);
        return this;
    }

    /**
     * 再起動オプションを取得します。
     *
     * @return 再起動オプション
     */
    @Query(name = "NiftyReboot")
    public String getNiftyReboot() {
        return niftyReboot;
    }

    /**
     * 再起動オプションを設定します。
     *
     * @param niftyReboot
     *            再起動オプション
     */
    public void setNiftyReboot(String niftyReboot) {
        this.niftyReboot = niftyReboot;
    }

    /**
     * 再起動オプションを設定し、自オブジェクトを返します。
     *
     * @param niftyReboot
     *            再起動オプション
     * @return 自オブジェクト
     */
    public DetachNetworkInterfaceRequest withNiftyReboot(String niftyReboot) {
        setNiftyReboot(niftyReboot);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[attachmentId=");
        builder.append(attachmentId);
        builder.append(", niftyReboot=");
        builder.append(niftyReboot);
        builder.append("]");
        return builder.toString();
    }
}
