/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.nic.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.Result;
import com.nifty.cloud.sdk.nic.model.transform.DescribeNetworkInterfacesResultConverter;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;

/**
 * DescribeNetworkInterfaces処理結果クラス。<br />
 * このクラスはDescribeNetworkInterfacesのレスポンスを格納します。
 */
@XStreamAlias("DescribeNetworkInterfacesResponse")
@XStreamConverter(DescribeNetworkInterfacesResultConverter.class)
public class DescribeNetworkInterfacesResult extends Result {

    /** リクエスト識別子 */
    @XStreamAlias("requestId")
    private String requestId;

    /** ネットワークインターフェースの情報セット */
    private List<NetworkInterfaceSet> networkInterfaceSets;

    /**
     * リクエスト識別子を取得します。
     *
     * @return リクエスト識別子
     */
    public String getRequestId() {
        return requestId;
    }

    /**
     * リクエスト識別子を設定します。
     *
     * @param requestId
     *            リクエスト識別子
     */
    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    /**
     * リクエスト識別子を設定し、自オブジェクトを返します。
     *
     * @param requestId
     *            リクエスト識別子
     * @return 自オブジェクト
     */
    public DescribeNetworkInterfacesResult withRequestId(String requestId) {
        setRequestId(requestId);
        return this;
    }

    /**
     * ネットワークインターフェースの情報セットを取得します。
     *
     * @return ネットワークインターフェースの情報セット
     */
    public List<NetworkInterfaceSet> getNetworkInterfaceSets() {
        return networkInterfaceSets;
    }

    /**
     * ネットワークインターフェースの情報セットを設定します。
     *
     * @param networkInterfaceSets
     *            ネットワークインターフェースの情報セット
     * 
     */
    public void setNetworkInterfaceSets(List<NetworkInterfaceSet> networkInterfaceSets) {
        this.networkInterfaceSets = networkInterfaceSets;
    }

    /**
     * ネットワークインターフェースの情報セットの配列を設定し、自オブジェクトを返します。
     *
     * @param networkInterfaceSets
     *            ネットワークインターフェースの情報セットの配列
     * @return 自オブジェクト
     */
    public DescribeNetworkInterfacesResult
        withNetworkInterfaceSets(NetworkInterfaceSet... networkInterfaceSets) {
        if (this.networkInterfaceSets == null)
            this.networkInterfaceSets = new ArrayList<NetworkInterfaceSet>();
        for (NetworkInterfaceSet networkInterfaceSet : networkInterfaceSets) {
            getNetworkInterfaceSets().add(networkInterfaceSet);
        }
        return this;
    }

    /**
     * ネットワークインターフェースの情報セットを設定し、自オブジェクトを返します。
     *
     * @param networkInterfaceSets
     *            ネットワークインターフェースの情報セット
     * @return 自オブジェクト
     */
    public DescribeNetworkInterfacesResult
        withNetworkInterfaceSets(Collection<NetworkInterfaceSet> networkInterfaceSets) {
        if (this.networkInterfaceSets == null)
            this.networkInterfaceSets = new ArrayList<NetworkInterfaceSet>();
        if (networkInterfaceSets != null) {
            getNetworkInterfaceSets().addAll(networkInterfaceSets);
        }
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[requestId=");
        builder.append(requestId);
        builder.append(",networkInterfaceSet=");
        builder.append(networkInterfaceSets);
        builder.append("]");
        return builder.toString();
    }
}
