/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.nic.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * DescribeNetworkInterfacesリクエストクラス。<br />
 * このクラスはDescribeNetworkInterfacesへのリクエストを構築します。
 */
@Action("DescribeNetworkInterfaces")
public class DescribeNetworkInterfacesRequest implements Request {

    /** ネットワークインターフェースIDリスト */
    private List<String> networkInterfaceIds;

    /** 絞り込み条件の項目名リスト */
    private List<Filter> filters;

    /**
     * デフォルトコンストラクタ。
     */
    public DescribeNetworkInterfacesRequest() {

    }

    /**
     * ネットワークインターフェースIDリストを取得します。
     * 
     * @return ネットワークインターフェースIDリスト
     */
    @Query(name = "NetworkInterfaceId")
    public List<String> getNetworkInterfaceIds() {
        return networkInterfaceIds;
    }

    /**
     * ネットワークインターフェースIDリストを設定します。
     * 
     * @param networkInterfaceId
     *            ネットワークインターフェースIDリスト
     */
    public void setNetworkInterfaceIds(List<String> networkInterfaceId) {
        this.networkInterfaceIds = networkInterfaceId;
    }

    /**
     * ネットワークインターフェースIDの配列を設定し、自オブジェクトを返します。
     * 
     * @param networkInterfaceIds
     *            ネットワークインターフェースIDリスト
     * @return 自オブジェクト
     */
    public DescribeNetworkInterfacesRequest withNetworkInterfaceIds(String... networkInterfaceIds) {
        if (this.networkInterfaceIds == null)
            this.networkInterfaceIds = new ArrayList<String>();
        for (String networkInterfaceId : networkInterfaceIds) {
            getNetworkInterfaceIds().add(networkInterfaceId);
        }
        return this;
    }

    /**
     * ネットワークインターフェースIDリストを設定し、自オブジェクトを返します。
     * 
     * @param networkInterfaceIds
     *            ネットワークインターフェースIDリスト
     * @return 自オブジェクト
     */
    public DescribeNetworkInterfacesRequest
        withNetworkInterfaceIds(Collection<String> networkInterfaceIds) {
        if (this.networkInterfaceIds == null)
            this.networkInterfaceIds = new ArrayList<String>();
        if (networkInterfaceIds != null) {
            getNetworkInterfaceIds().addAll(networkInterfaceIds);
        }
        return this;
    }

    /**
     * 絞り込み条件の項目名リストを取得します。
     * 
     * @return 絞り込み条件の項目名リスト
     */
    @Query(name = "Filter")
    public List<Filter> getFilters() {
        return filters;
    }

    /**
     * 絞り込み条件の項目名リストを設定します。
     * 
     * @param filters
     *            絞り込み条件の項目名リスト
     */
    public void setFilters(List<Filter> filters) {
        this.filters = filters;
    }

    /**
     * 絞り込み条件の項目名リストを設定し、自オブジェクトを返します。
     * 
     * @param filters
     *            絞り込み条件の項目名リスト
     * @return 自オブジェクト
     */
    public DescribeNetworkInterfacesRequest withFilters(Filter... filters) {
        if (this.filters == null)
            this.filters = new ArrayList<Filter>();
        for (Filter filter : filters) {
            getFilters().add(filter);
        }
        return this;
    }

    /**
     * 絞り込み条件の項目名リストを設定し、自オブジェクトを返します。
     * 
     * @param filters
     *            絞り込み条件の項目名リスト
     * @return 自オブジェクト
     */
    public DescribeNetworkInterfacesRequest withFilters(Collection<Filter> filters) {
        if (this.filters == null)
            this.filters = new ArrayList<Filter>();
        if (filters != null) {
            getFilters().addAll(filters);
        }
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[networkInterfaceIds=");
        builder.append(networkInterfaceIds);
        builder.append(" filters=");
        builder.append(filters);
        builder.append("]");
        return builder.toString();
    }
}
