/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.nic.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * DeleteNetworkInterfaceリクエストクラス。<br />
 * このクラスはDeleteNetworkInterfaceへのリクエストを構築します。
 *
 */
@Action("DeleteNetworkInterface")
public class DeleteNetworkInterfaceRequest implements Request {

    /** ネットワークインターフェースID */
    private String networkInterfaceId;

    /**
     * デフォルトコンストラクタ。
     */
    public DeleteNetworkInterfaceRequest() {

    }

    /**
     * ネットワークインターフェースIDを指定し、DeleteNetworkInterfaceRequestを構築します。
     * 
     * @param networkInterfaceId
     *            ネットワークインターフェースID
     */
    public DeleteNetworkInterfaceRequest(String networkInterfaceId) {
        this.networkInterfaceId = networkInterfaceId;
    }

    /**
     * ネットワークインターフェースIDを取得します。
     *
     * @return ネットワークインターフェースID
     */
    @Query(name = "NetworkInterfaceId", require = true)
    public String getNetworkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * ネットワークインターフェースIDを設定します。
     *
     * @param networkInterfaceId
     *            ネットワークインターフェースID
     */
    public void setNetworkInterfaceId(String networkInterfaceId) {
        this.networkInterfaceId = networkInterfaceId;
    }

    /**
     * ネットワークインターフェースIDを設定し、自オブジェクトを返します。
     *
     * @param networkInterfaceId
     *            ネットワークインターフェースID
     * @return 自オブジェクト
     */
    public DeleteNetworkInterfaceRequest withNetworkInterfaceId(String networkInterfaceId) {
        setNetworkInterfaceId(networkInterfaceId);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[networkInterfaceId=");
        builder.append(networkInterfaceId);
        builder.append("]");
        return builder.toString();
    }
}
