/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.nic.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * CreateNetworkInterfaceリクエストクラス。<br />
 * このクラスはCreateNetworkInterfaceへのリクエストを構築します。
 */
@Action("CreateNetworkInterface")
public class CreateNetworkInterfaceRequest implements Request {

    /** ネットワークユニークID */
    private String niftyNetworkId;

    /** IPアドレス */
    private String ipAddress;

    /** ゾーン情報 */
    private Placement placement;

    /** メモ情報 */
    private String description;

    /**
     * デフォルトコンストラクタ。
     */
    public CreateNetworkInterfaceRequest() {

    }

    /**
     * ネットワークユニークIDを指定し、CreateNetworkInterfaceRequestを構築します。
     * 
     * @param niftyNetworkId
     *            ネットワークユニークID
     */
    public CreateNetworkInterfaceRequest(String niftyNetworkId) {
        this.niftyNetworkId = niftyNetworkId;
    }

    /**
     * ネットワークユニークIDを取得します。
     *
     * @return ネットワークユニークID
     */
    @Query(name = "NiftyNetworkId", require = true)
    public String getNiftyNetworkId() {
        return niftyNetworkId;
    }

    /**
     * ネットワークユニークIDを設定します。
     *
     * @param niftyNetworkId
     *            ネットワークユニークID
     */
    public void setNiftyNetworkId(String niftyNetworkId) {
        this.niftyNetworkId = niftyNetworkId;
    }

    /**
     * ネットワークユニークIDを設定し、自オブジェクトを返します。
     *
     * @param niftyNetworkId
     *            ネットワークユニークID
     * @return 自オブジェクト
     */
    public CreateNetworkInterfaceRequest withNiftyNetworkId(String niftyNetworkId) {
        setNiftyNetworkId(niftyNetworkId);
        return this;
    }

    /**
     * IPアドレスを取得します。
     *
     * @return IPアドレス
     */
    @Query(name = "IpAddress")
    public String getIpAddress() {
        return ipAddress;
    }

    /**
     * IPアドレスを設定します。
     *
     * @param ipAddress
     *            IPアドレス
     */
    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    /**
     * IPアドレスを設定し、自オブジェクトを返します。
     *
     * @param ipAddress
     *            IPアドレス
     * @return 自オブジェクト
     */
    public CreateNetworkInterfaceRequest withIpAddress(String ipAddress) {
        setIpAddress(ipAddress);
        return this;
    }

    /**
     * ゾーン情報を取得します。
     *
     * @return ゾーン情報
     */
    @Query(name = "Placement")
    public Placement getPlacement() {
        return placement;
    }

    /**
     * ゾーン情報を設定します。
     *
     * @param placement
     *            ゾーン情報
     */
    public void setPlacement(Placement placement) {
        this.placement = placement;
    }

    /**
     * ゾーン情報を設定し、自オブジェクトを返します。
     *
     * @param placement
     *            ゾーン情報
     * @return 自オブジェクト
     */
    public CreateNetworkInterfaceRequest withPlacement(Placement placement) {
        setPlacement(placement);
        return this;
    }

    /**
     * メモを取得します。
     *
     * @return メモ
     */
    @Query(name = "Description")
    public String getDescription() {
        return description;
    }

    /**
     * メモを設定します。
     *
     * @param description
     *            メモ
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * メモを設定し、自オブジェクトを返します。
     *
     * @param description
     *            メモ
     * @return 自オブジェクト
     */
    public CreateNetworkInterfaceRequest withDescription(String description) {
        setDescription(description);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[niftyNetworkId=");
        builder.append(niftyNetworkId);
        builder.append(", ipAddress=");
        builder.append(ipAddress);
        builder.append(", placement=");
        builder.append(placement);
        builder.append(", description=");
        builder.append(description);
        builder.append("]");
        return builder.toString();
    }
}
