/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.nic.model;

/**
 * アタッチメントクラス。<br />
 * このクラスはAttachment情報を格納します。
 */
public class Attachment {

    /** アタッチメントID */
    private String attachmentId;

    /** サーバーへの接続時刻 */
    private String attachTime;

    /** サーバー削除時のネットワークインターフェース消去 */
    private Boolean deleteOnTermination;

    /** デバイス番号 */
    private String deviceIndex;

    /** サーバー名 */
    private String instanceId;

    private String instanceOwnerId;

    /** ネットワークインターフェースのステータス */
    private String status;

    /**
     * アタッチメントID を取得します。
     *
     * @return アタッチメントID
     */
    public String getAttachmentId() {
        return attachmentId;
    }

    /**
     * アタッチメントID を設定します。
     *
     * @param attachmentId
     *            アタッチメントID
     */
    public void setAttachmentId(String attachmentId) {
        this.attachmentId = attachmentId;
    }

    /**
     * アタッチメントID を設定し、自オブジェクトを返します。
     *
     * @param attachmentId
     *            アタッチメントID
     * @return 自オブジェクト
     */
    public Attachment withAttachmentId(String attachmentId) {
        setAttachmentId(attachmentId);
        return this;
    }

    /**
     * サーバーへの接続時刻を取得します。
     *
     * @return サーバーへの接続時刻
     */
    public String getAttachTime() {
        return attachTime;
    }

    /**
     * サーバーへの接続時刻を設定します。
     *
     * @param attachTime
     *            サーバーへの接続時刻
     */
    public void setAttachTime(String attachTime) {
        this.attachTime = attachTime;
    }

    /**
     * サーバーへの接続時刻を設定し、自オブジェクトを返します。
     *
     * @param attachTime
     *            サーバーへの接続時刻
     * @return 自オブジェクト
     */
    public Attachment withAttachTime(String attachTime) {
        setAttachTime(attachTime);
        return this;
    }

    /**
     * サーバー削除時のネットワークインターフェース消去を取得します。
     *
     * @return サーバー削除時のネットワークインターフェース消去
     */
    public Boolean getDeleteOnTermination() {
        return deleteOnTermination;
    }

    /**
     * サーバー削除時のネットワークインターフェース消去を設定します。
     *
     * @param deleteOnTermination
     *            サーバー削除時のネットワークインターフェース消去
     */
    public void setDeleteOnTermination(Boolean deleteOnTermination) {
        this.deleteOnTermination = deleteOnTermination;
    }

    /**
     * サーバー削除時のネットワークインターフェース消去を設定し、自オブジェクトを返します。
     *
     * @param deleteOnTermination
     *            サーバー削除時のネットワークインターフェース消去
     * @return 自オブジェクト
     */
    public Attachment withDeleteOnTermination(Boolean deleteOnTermination) {
        setDeleteOnTermination(deleteOnTermination);
        return this;
    }

    /**
     * デバイス番号を取得します。
     *
     * @return デバイス番号
     */
    public String getDeviceIndex() {
        return deviceIndex;
    }

    /**
     * デバイス番号を設定します。
     *
     * @param deviceIndex
     *            デバイス番号
     */
    public void setDeviceIndex(String deviceIndex) {
        this.deviceIndex = deviceIndex;
    }

    /**
     * デバイス番号を設定し、自オブジェクトを返します。
     *
     * @param deviceIndex
     *            デバイス番号
     * @return 自オブジェクト
     */
    public Attachment withDeviceIndex(String deviceIndex) {
        setDeviceIndex(deviceIndex);
        return this;
    }

    /**
     * サーバー名を取得します。
     * 
     * @return サーバー名
     */
    public String getInstanceId() {
        return instanceId;
    }

    /**
     * サーバー名を設定します。
     * 
     * @param instanceId
     *            サーバー名
     */
    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    /**
     * サーバー名を設定し、自オブジェクトを返します。
     *
     * @param instanceId
     *            サーバー名
     * @return 自オブジェクト
     */
    public Attachment withInstanceId(String instanceId) {
        setInstanceId(instanceId);
        return this;
    }

    /**
     * instanceOwnerIdを取得します。
     *
     * @return instanceOwnerId
     */
    public String getInstanceOwnerId() {
        return instanceOwnerId;
    }

    /**
     * instanceOwnerIdを設定します。
     *
     * @param instanceOwnerId
     */
    public void setInstanceOwnerId(String instanceOwnerId) {
        this.instanceOwnerId = instanceOwnerId;
    }

    /**
     * instanceOwnerIdを設定し、自オブジェクトを返します。
     *
     * @param instanceOwnerId
     * @return 自オブジェクト
     */
    public Attachment withInstanceOwnerId(String instanceOwnerId) {
        setInstanceOwnerId(instanceOwnerId);
        return this;
    }

    /**
     * 接続状態を取得します。
     *
     * @return 接続状態
     */
    public String getStatus() {
        return status;
    }

    /**
     * 接続状態を設定します。
     *
     * @param status
     *            接続状態
     */
    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * 接続状態を設定し、自オブジェクトを返します。
     *
     * @param status
     *            接続状態
     * @return 自オブジェクト
     */
    public Attachment withStatus(String status) {
        setStatus(status);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[attachmentId=");
        builder.append(attachmentId);
        builder.append(", attachTime=");
        builder.append(attachTime);
        builder.append(", deleteOnTermination=");
        builder.append(deleteOnTermination);
        builder.append(", deviceIndex=");
        builder.append(deviceIndex);
        builder.append(", instanceId=");
        builder.append(instanceId);
        builder.append(", instanceOwnerId=");
        builder.append(instanceOwnerId);
        builder.append(", status=");
        builder.append(status);
        builder.append("]");
        return builder.toString();
    }

}