/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.nic.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * AttachNetworkInterfaceリクエストクラス。<br />
 * このクラスはAttachNetworkInterfaceへのリクエストを構築します。
 *
 */
@Action("AttachNetworkInterface")
public class AttachNetworkInterfaceRequest implements Request {

    /** サーバー名 */
    private String instanceId;

    /** サーバーユニークID */
    private String instanceUniqueId;

    /** ネットワークインターフェースID */
    private String networkInterfaceId;

    /** 再起動オプション */
    private String niftyReboot;

    /**
     * デフォルトコンストラクタ。
     */
    public AttachNetworkInterfaceRequest() {

    }

    /**
     * networkInterfaceId ネットワークインターフェースIDを指定し、AttachNetworkInterfaceRequestを構築します。
     *
     * @param networkInterfaceId
     *            ネットワークインターフェースID
     */
    public AttachNetworkInterfaceRequest(String networkInterfaceId) {
        this.networkInterfaceId = networkInterfaceId;
    }

    /**
     * サーバー名を取得します。
     *
     * @return サーバー名
     */
    @Query(name = "InstanceId")
    public String getInstanceId() {
        return instanceId;
    }

    /**
     * サーバー名を設定します。
     *
     * @param instanceId
     *            サーバー名
     */
    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    /**
     * サーバー名を設定し、自オブジェクトを返します。
     *
     * @param instanceId
     *            サーバー名
     * @return 自オブジェクト
     */
    public AttachNetworkInterfaceRequest withInstanceId(String instanceId) {
        setInstanceId(instanceId);
        return this;
    }

    /**
     * サーバーユニークIDを取得します。
     *
     * @return サーバーユニークID
     */
    @Query(name = "InstanceUniqueId")
    public String getInstanceUniqueId() {
        return instanceUniqueId;
    }

    /**
     * サーバーユニークIDを設定します。
     *
     * @param instanceUniqueId
     *            サーバーユニークID
     */
    public void setInstanceUniqueId(String instanceUniqueId) {
        this.instanceUniqueId = instanceUniqueId;
    }

    /**
     * サーバーユニークIDを設定し、自オブジェクトを返します。
     *
     * @param instanceUniqueId
     *            サーバーユニークID
     * @return 自オブジェクト
     */
    public AttachNetworkInterfaceRequest withInstanceUniqueId(String instanceUniqueId) {
        setInstanceUniqueId(instanceUniqueId);
        return this;
    }

    /**
     * ネットワークインターフェースIDを取得します。
     *
     * @return ネットワークインターフェースID
     */
    @Query(name = "NetworkInterfaceId", require = true)
    public String getNetworkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * ネットワークインターフェースIDを設定します。
     *
     * @param networkInterfaceId
     *            ネットワークインターフェースID
     */
    public void setNetworkInterfaceId(String networkInterfaceId) {
        this.networkInterfaceId = networkInterfaceId;
    }

    /**
     * ネットワークインターフェースIDを設定し、自オブジェクトを返します。
     *
     * @param networkInterfaceId
     *            ネットワークインターフェースID
     * @return 自オブジェクト
     */
    public AttachNetworkInterfaceRequest withNetworkInterfaceId(String networkInterfaceId) {
        setNetworkInterfaceId(networkInterfaceId);
        return this;
    }

    /**
     * 再起動オプションを取得します。
     *
     * @return 再起動オプション
     */
    @Query(name = "NiftyReboot")
    public String getNiftyReboot() {
        return niftyReboot;
    }

    /**
     * 再起動オプションを設定します。
     *
     * @param niftyReboot
     *            再起動オプション
     */
    public void setNiftyReboot(String niftyReboot) {
        this.niftyReboot = niftyReboot;
    }

    /**
     * 再起動オプションを設定し、自オブジェクトを返します。
     *
     * @param niftyReboot
     *            再起動オプション
     * @return 自オブジェクト
     */
    public AttachNetworkInterfaceRequest withNiftyReboot(String niftyReboot) {
        setNiftyReboot(niftyReboot);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[instanceId=");
        builder.append(instanceId);
        builder.append(", instanceUniqueId=");
        builder.append(instanceUniqueId);
        builder.append(", networkInterfaceId=");
        builder.append(networkInterfaceId);
        builder.append(", niftyReboot=");
        builder.append(niftyReboot);
        builder.append("]");
        return builder.toString();
    }
}
