/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.nic.model;

/**
 * アソシエーションクラス。<br />
 * このクラスはAssociation情報を格納します。
 */
public class Association {

    private String allocationId;

    private String associationId;

    private String ipOwnerId;

    private String publicDnsName;

    private String publicIp;

    /**
     * AllocationIdを取得します。
     *
     * @return AllocationId
     */
    public String getAllocationId() {
        return allocationId;
    }

    /**
     * AllocationIdを設定します。
     *
     * @param allocationId
     */
    public void setAllocationId(String allocationId) {
        this.allocationId = allocationId;
    }

    /**
     * AllocationIdを設定し、自オブジェクトを返します。
     *
     * @param allocationId
     * @return 自オブジェクト
     */
    public Association withAllocationId(String allocationId) {
        setAllocationId(allocationId);
        return this;
    }

    /**
     * associationIdを取得します。
     *
     * @return associationId
     */
    public String getAssociationId() {
        return associationId;
    }

    /**
     * associationIdを設定します。
     *
     * @param associationId
     */
    public void setAssociationId(String associationId) {
        this.associationId = associationId;
    }

    /**
     * associationIdを設定し、自オブジェクトを返します。
     *
     * @param associationId
     * @return 自オブジェクト
     */
    public Association withAssociationId(String associationId) {
        setAssociationId(associationId);
        return this;
    }

    /**
     * publicIpを取得します。
     *
     * @return publicIp
     */
    public String getPublicIp() {
        return publicIp;
    }

    /**
     * publicIpを設定します。
     *
     * @param publicIp
     * 
     */
    public void setPublicIp(String publicIp) {
        this.publicIp = publicIp;
    }

    /**
     * publicIpを設定し、自オブジェクトを返します。
     *
     * @param publicIp
     * 
     * @return 自オブジェクト
     */
    public Association withPublicIp(String publicIp) {
        setPublicIp(publicIp);
        return this;
    }

    /**
     * publicDnsNameを取得します。
     *
     * @return publicDnsName
     */
    public String getPublicDnsName() {
        return publicDnsName;
    }

    /**
     * publicDnsNameを設定します。
     *
     * @param publicDnsName
     */
    public void setPublicDnsName(String publicDnsName) {
        this.publicDnsName = publicDnsName;
    }

    /**
     * publicDnsNameを設定し、自オブジェクトを返します。
     *
     * @param publicDnsName
     * @return 自オブジェクト
     */
    public Association withPublicDnsName(String publicDnsName) {
        setPublicDnsName(publicDnsName);
        return this;
    }

    /**
     * ipOwnerIdを取得します。
     *
     * @return ipOwnerId
     */
    public String getIpOwnerId() {
        return ipOwnerId;
    }

    /**
     * ipOwnerIdを設定します。
     *
     * @param ipOwnerId
     */
    public void setIpOwnerId(String ipOwnerId) {
        this.ipOwnerId = ipOwnerId;
    }

    /**
     * ipOwnerIdを設定し、自オブジェクトを返します。
     *
     * @param ipOwnerId
     * @return 自オブジェクト
     */
    public Association withIpOwnerId(String ipOwnerId) {
        setIpOwnerId(ipOwnerId);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[allocationId=");
        builder.append(allocationId);
        builder.append(", associationId=");
        builder.append(associationId);
        builder.append(", ipOwnerId=");
        builder.append(ipOwnerId);
        builder.append(", publicDnsName=");
        builder.append(publicDnsName);
        builder.append(", publicIp=");
        builder.append(publicIp);
        builder.append("]");
        return builder.toString();
    }

}
