/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.nic;

import com.nifty.cloud.sdk.BaseClient;
import com.nifty.cloud.sdk.ClientConfiguration;
import com.nifty.cloud.sdk.auth.Credentials;
import com.nifty.cloud.sdk.nic.model.AttachNetworkInterfaceRequest;
import com.nifty.cloud.sdk.nic.model.AttachNetworkInterfaceResult;
import com.nifty.cloud.sdk.nic.model.CreateNetworkInterfaceRequest;
import com.nifty.cloud.sdk.nic.model.CreateNetworkInterfaceResult;
import com.nifty.cloud.sdk.nic.model.DeleteNetworkInterfaceRequest;
import com.nifty.cloud.sdk.nic.model.DeleteNetworkInterfaceResult;
import com.nifty.cloud.sdk.nic.model.DescribeNetworkInterfacesRequest;
import com.nifty.cloud.sdk.nic.model.DescribeNetworkInterfacesResult;
import com.nifty.cloud.sdk.nic.model.DetachNetworkInterfaceRequest;
import com.nifty.cloud.sdk.nic.model.DetachNetworkInterfaceResult;
import com.nifty.cloud.sdk.nic.model.ModifyNetworkInterfaceAttributeRequest;
import com.nifty.cloud.sdk.nic.model.ModifyNetworkInterfaceAttributeResult;

/**
 * NIFCLOUD API クライアント 具象クラス。 追加NICカテゴリ クライアント。<br />
 * 追加NICカテゴリの同期クライアントの具象クラスです。<br />
 * 戻り値の"利用不可"パラメータは返却値がnullまたは空となります。
 */
public class NiftyNicClient extends BaseClient implements NiftyNic {

    /**
     * 認証情報を指定し、追加NICカテゴリクライアントを構築します。
     *
     * @param credential
     *            認証情報
     */
    public NiftyNicClient(Credentials credential) {
        super(credential, new ClientConfiguration());
    }

    /**
     * 認証情報、クライアント設定を指定し、追加NICカテゴリクライアントを構築します。
     *
     * @param credential
     *            認証情報
     * @param configuration
     *            クライアント設定
     */
    public NiftyNicClient(Credentials credential, ClientConfiguration configuration) {
        super(credential, configuration);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public CreateNetworkInterfaceResult
        createNetworkInterface(CreateNetworkInterfaceRequest request) {
        return (CreateNetworkInterfaceResult) client.execute(request,
            CreateNetworkInterfaceResult.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DescribeNetworkInterfacesResult
        describeNetworkInterfaces(DescribeNetworkInterfacesRequest request) {
        return (DescribeNetworkInterfacesResult) client.execute(request,
            DescribeNetworkInterfacesResult.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AttachNetworkInterfaceResult
        attachNetworkInterface(AttachNetworkInterfaceRequest request) {

        return (AttachNetworkInterfaceResult) client.execute(request,
            AttachNetworkInterfaceResult.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DetachNetworkInterfaceResult
        detachNetworkInterface(DetachNetworkInterfaceRequest request) {

        return (DetachNetworkInterfaceResult) client.execute(request,
            DetachNetworkInterfaceResult.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DeleteNetworkInterfaceResult
        deleteNetworkInterface(DeleteNetworkInterfaceRequest request) {

        return (DeleteNetworkInterfaceResult) client.execute(request,
            DeleteNetworkInterfaceResult.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ModifyNetworkInterfaceAttributeResult
        modifyNetworkInterfaceAttribute(ModifyNetworkInterfaceAttributeRequest request) {

        return (ModifyNetworkInterfaceAttributeResult) client.execute(request,
            ModifyNetworkInterfaceAttributeResult.class);
    }

}