/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.nic;

import java.util.concurrent.Future;

import com.nifty.cloud.sdk.nic.model.AttachNetworkInterfaceRequest;
import com.nifty.cloud.sdk.nic.model.AttachNetworkInterfaceResult;
import com.nifty.cloud.sdk.nic.model.CreateNetworkInterfaceRequest;
import com.nifty.cloud.sdk.nic.model.CreateNetworkInterfaceResult;
import com.nifty.cloud.sdk.nic.model.DeleteNetworkInterfaceRequest;
import com.nifty.cloud.sdk.nic.model.DeleteNetworkInterfaceResult;
import com.nifty.cloud.sdk.nic.model.DescribeNetworkInterfacesRequest;
import com.nifty.cloud.sdk.nic.model.DescribeNetworkInterfacesResult;
import com.nifty.cloud.sdk.nic.model.DetachNetworkInterfaceRequest;
import com.nifty.cloud.sdk.nic.model.DetachNetworkInterfaceResult;
import com.nifty.cloud.sdk.nic.model.ModifyNetworkInterfaceAttributeRequest;
import com.nifty.cloud.sdk.nic.model.ModifyNetworkInterfaceAttributeResult;

/**
 * NIFCLOUD API 非同期クライアント インタフェース。 追加NICカテゴリクライアント。<br />
 * 追加NICカテゴリの非同期クライアントのインタフェースです。<br />
 * 戻り値の"利用不可"パラメータは返却値がnullまたは空となります。
 */

public interface NiftyNicAsync extends NiftyNic {

    /**
     * 非同期で追加NICを新規作成します。
     *
     * @param request
     *            CreateNetworkInterfaceリクエスト
     * @return 非同期処理結果
     */
    public Future<CreateNetworkInterfaceResult>
        createNetworkInterfaceAsync(CreateNetworkInterfaceRequest request);

    /**
     * 非同期で追加NICの情報を取得します。
     *
     * @param request
     *            DescribeNetworkInterfacesリクエスト
     * @return 非同期処理結果
     */
    public Future<DescribeNetworkInterfacesResult>
        describeNetworkInterfacesAsync(DescribeNetworkInterfacesRequest request);

    /**
     * 非同期で指定したサーバーに追加NICを接続します。
     * 
     * @param request
     *            AttachNetworkInterfaceリクエスト
     * @return 非同期処理結果
     */
    public Future<AttachNetworkInterfaceResult>
        attachNetworkInterfaceAsync(AttachNetworkInterfaceRequest request);

    /**
     * 非同期でサーバーに接続した追加NICを解除します。
     * 
     * @param request
     *            DetachNetworkInterfaceリクエスト
     * @return 非同期処理結果
     */
    public Future<DetachNetworkInterfaceResult>
        detachNetworkInterfaceAsync(DetachNetworkInterfaceRequest request);

    /**
     * 非同期で追加NICの削除を行います。
     * 
     * @param request
     *            DeleteNetworkInterfaceリクエスト
     * @return 非同期処理結果
     */
    public Future<DeleteNetworkInterfaceResult>
        deleteNetworkInterfaceAsync(DeleteNetworkInterfaceRequest request);

    /**
     * 非同期で追加NICの属性情報の更新を行います。
     * 
     * @param request
     *            ModifyNetworkInterfaceAttributeリクエスト
     * @return 非同期処理結果
     */
    public Future<ModifyNetworkInterfaceAttributeResult>
        modifyNetworkInterfaceAttributeAsync(ModifyNetworkInterfaceAttributeRequest request);
}
