/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.nattable.model.transform;

import java.util.ArrayList;
import java.util.List;

import com.nifty.cloud.sdk.nattable.model.NatRule;
import com.nifty.cloud.sdk.nattable.model.NatTableAssociation;
import com.nifty.cloud.sdk.nattable.model.NatTableSet;
import com.nifty.cloud.sdk.nattable.model.Tag;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

/**
 * NatTableSetType変換クラス。<br />
 * このクラスはレスポンスXMLのnatTableSet要素からNatTableSetクラスのリストを生成します。
 */
public class NatTableSetConverter implements Converter {

	private static final String ELEMENT_NAT_TABLE_ID = "natTableId";
	private static final String ELEMENT_NAT_RULE_SET = "natRuleSet";
	private static final String ELEMENT_ASSOCIATION_SET = "associationSet";
	private static final String ELEMENT_TAG_SET = "tagSet";

	/**
	 * 変換可能なクラスか判定します。
	 *
	 * @param clazz クラス
	 * @return 変換可能な場合true, 変換不可能な場合false
	 *
	 * @see com.thoughtworks.xstream.converters.Converter#canConvert(Class)
	 */
	@SuppressWarnings("rawtypes")
	@Override
	public boolean canConvert(Class clazz) {
		Class[] interfaces = clazz.getInterfaces();
		for (Class i : interfaces) {
			if (i == List.class) {
				return true;
			}
		}
		return false;
	}

	/**
	 * {@literal
	 * natTableSetをList<NatTableSet>クラスに変換します。}
	 *
	 * @param reader XML読込リーダ
	 * @param context
	 * @return {@literal List<NatTableSet>オブジェクト}
	 *
	 * @see com.thoughtworks.xstream.converters.Converter#unmarshal(HierarchicalStreamReader, UnmarshallingContext)
	 */
	@SuppressWarnings("unchecked")
	@Override
	public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
		List<NatTableSet> natTableSets = new ArrayList<NatTableSet>();
		Converter natRuleSetConverter = new NatRuleSetConverter();
		Converter associationSetConverter = new AssociationSetConverter();
		Converter tagSetConverter = new TagSetConverter();
		String name = null;

		while (reader.hasMoreChildren()) {
			reader.moveDown();
			NatTableSet natTableSet = new NatTableSet();

			while (reader.hasMoreChildren()) {
				reader.moveDown();

				name = reader.getNodeName();
				if (name.equals(ELEMENT_NAT_TABLE_ID)) {
					natTableSet.setNatTableId(reader.getValue());
				} else if (name.equals(ELEMENT_NAT_RULE_SET)) {
					natTableSet.setNatRules((List<NatRule>) natRuleSetConverter.unmarshal(reader, context));
				} else if (name.equals(ELEMENT_ASSOCIATION_SET)) {
					natTableSet.setAssociations((List<NatTableAssociation>) associationSetConverter.unmarshal(reader, context));
				} else if (name.equals(ELEMENT_TAG_SET)) {
					natTableSet.setTagSet((List<Tag>) tagSetConverter.unmarshal(reader, context));
				}
				reader.moveUp();
			}
			reader.moveUp();
			natTableSets.add(natTableSet);
		}
		return natTableSets;
	}

	/**
	 * 未実装メソッド
	 */
	@Override
	public void marshal(Object paramObject,
			HierarchicalStreamWriter paramHierarchicalStreamWriter,
			MarshallingContext paramMarshallingContext) {
	}
}
