/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.nattable.model.transform;

import java.util.ArrayList;
import java.util.List;

import com.nifty.cloud.sdk.nattable.model.NatTableAssociation;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

/**
 * NatTableAssociationSetType変換クラス。<br />
 * このクラスはレスポンスXMLのassociationSet要素からNatTableAssociationクラスのリストを生成します。
 *
 */
public class AssociationSetConverter implements Converter {

	private static final String ELEMENT_ASSOCIATION_ID = "associationId";
	private static final String ELEMENT_NATTABLE_ID = "natTableId";
	private static final String ELEMENT_ROUTER_ID = "routerId";
	private static final String ELEMENT_ROUTER_NAME = "routerName";

	/**
	 * 変換可能なクラスか判定します。
	 *
	 * @param clazz クラス
	 * @return 変換可能な場合true, 変換不可能な場合false
	 *
	 * @see com.thoughtworks.xstream.converters.Converter#canConvert(Class)
	 */
	@SuppressWarnings("rawtypes")
	@Override
	public boolean canConvert(Class clazz) {
		Class[] interfaces = clazz.getInterfaces();
		for (Class i : interfaces) {
			if (i == List.class) {
				return true;
			}
		}
		return false;
	}

	/**
	 * {@literal
	 * associationSetをList<NatTableAssociation>クラスに変換します。}
	 *
	 * @param reader XML読込リーダ
	 * @param context
	 * @return {@literal List<NatTableAssociation>オブジェクト}
	 *
	 * @see com.thoughtworks.xstream.converters.Converter#unmarshal(HierarchicalStreamReader, UnmarshallingContext)
	 */
	@Override
	public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
		List<NatTableAssociation> natTableAssociations = new ArrayList<NatTableAssociation>();
		String name = null;

		while (reader.hasMoreChildren()) {
			reader.moveDown();
			NatTableAssociation natTableAssociation = new NatTableAssociation();

			while(reader.hasMoreChildren()) {
				reader.moveDown();
				name = reader.getNodeName();
				if (name.equals(ELEMENT_ASSOCIATION_ID)) {
					natTableAssociation.setAssociationId(reader.getValue());
				} else if (name.equals(ELEMENT_NATTABLE_ID)) {
					natTableAssociation.setNatTableId(reader.getValue());
				} else if (name.equals(ELEMENT_ROUTER_ID)) {
					natTableAssociation.setRouterId(reader.getValue());
				} else if (name.equals(ELEMENT_ROUTER_NAME)) {
					natTableAssociation.setRouterName(reader.getValue());
				}
				reader.moveUp();
			}
			reader.moveUp();
			natTableAssociations.add(natTableAssociation);
		}
		return natTableAssociations;
	}

	/**
	 * 未実装メソッド
	 */
	@Override
	public void marshal(Object paramObject,
			HierarchicalStreamWriter paramHierarchicalStreamWriter,
			MarshallingContext paramMarshallingContext) {
	}

}
