/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.nattable.model;

import com.nifty.cloud.sdk.annotation.Query;

/**
 * 変換情報クラス。<br />
 * このクラスは変換情報を格納します。
 *
 */
public class Translation {

	/** アドレス */
	private String address;

	/** ポート */
	private Integer port;

	/**
	 * アドレスを取得します。
	 *
	 * @return address アドレス
	 */
	@Query(name="Address")
	public String getAddress() {
		return address;
	}

	/**
	 * アドレスを設定します。
	 *
	 * @param address アドレス
	 */
	public void setAddress(String address) {
		this.address = address;
	}

	/**
	 * アドレスを設定し、自オブジェクトを返します。
	 *
	 * @param address アドレス
	 * @return 自オブジェクト
	 */
	public Translation withAddress(String address) {
		setAddress(address);
		return this;
	}

	/**
	 * ポートを取得します。
	 *
	 * @return port ポート
	 */
	@Query(name="Port")
	public Integer getPort() {
		return port;
	}

	/**
	 * ポートを設定します。
	 *
	 * @param port ポート
	 */
	public void setPort(Integer port) {
		this.port = port;
	}

	/**
	 * ポートを設定し、自オブジェクトを返します。
	 *
	 * @param port ポート
	 * @return 自オブジェクト
	 */
	public Translation withPort(Integer port) {
		setPort(port);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[address=");
		builder.append(address);
		builder.append(", port=");
		builder.append(port);
		builder.append("]");
		return builder.toString();
	}
}
