/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.nattable.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftyReplaceNatRuleリクエストクラス。<br />
 * このクラスはNiftyReplaceNatRuleへのリクエストを構築します。
 *
 */
@Action("NiftyReplaceNatRule")
public class NiftyReplaceNatRuleRequest implements Request {

	/** NATテーブルID */
	private String natTableId;

	/** NATルール情報 */
	private NatRule natRule;

	/**
	 * デフォルトコンストラクタ。
	 */
	public NiftyReplaceNatRuleRequest() {
	}

	/**
	 * NATテーブルID,NATルール情報を指定し、NiftyReplaceNatRuleRequestを構築します。
	 *
	 * @param natTableId NATテーブルID
	 * @param natRule NATルール情報
	 */
	public NiftyReplaceNatRuleRequest(String natTableId, NatRule natRule) {
		this.natTableId = natTableId;
		this.natRule = natRule;
	}

	/**
	 * NATテーブルIDを取得します。
	 *
	 * @return NATテーブルID
	 */
	@Query(name="NatTableId", require=true)
	public String getNatTableId() {
		return natTableId;
	}

	/**
	 * NATテーブルIDを設定します。
	 *
	 * @param natTableId NATテーブルID
	 */
	public void setNatTableId(String natTableId) {
		this.natTableId = natTableId;
	}

	/**
	 * NATテーブルIDを設定し、自オブジェクトを返します。
	 *
	 * @param natTableId NATテーブルID
	 * @return 自オブジェクト
	 */
	public NiftyReplaceNatRuleRequest withNatTableId(String natTableId) {
		setNatTableId(natTableId);
		return this;
	}

	/**
	 * NATルール情報を取得します。
	 *
	 * @return NATルール情報
	 */
	@Query(name="", require=true)
	public NatRule getNatRule() {
		return natRule;
	}

	/**
	 * NATルール情報を設定します。
	 *
	 * @param natRule NATルール情報
	 */
	public void setNatRule(NatRule natRule) {
		this.natRule = natRule;
	}

	/**
	 * NATルール情報を設定し、自オブジェクトを返します。
	 *
	 * @param natRule NATルール情報
	 * @return 自オブジェクト
	 */
	public NiftyReplaceNatRuleRequest withNatRule(NatRule natRule) {
		setNatRule(natRule);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[natTableId=");
		builder.append(natTableId);
		builder.append(", natRule=");
		builder.append(natRule);
		builder.append("]");
		return builder.toString();
	}
}
