/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.nattable.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.Result;
import com.nifty.cloud.sdk.nattable.model.transform.NiftyDescribeNatTablesResultConverter;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;

/**
 * NiftyDescribeNatTables処理結果クラス。<br />
 * このクラスはNiftyDescribeNatTablesのレスポンスを格納します。
 */
@XStreamAlias("NiftyDescribeNatTablesResponse")
@XStreamConverter(NiftyDescribeNatTablesResultConverter.class)
public class NiftyDescribeNatTablesResult extends Result {

	/** リクエスト識別子 */
	private String requestId;

	/** NATテーブル情報リスト */
	private List<NatTableSet> natTables;

	/**
	 * リクエスト識別子を取得します。
	 *
	 * @return リクエスト識別子
	 */
	public String getRequestId() {
		return requestId;
	}

	/**
	 * リクエスト識別子を設定します。
	 *
	 * @param requestId リクエスト識別子
	 */
	public void setRequestId(String requestId) {
		this.requestId = requestId;
	}

	/**
	 * リクエスト識別子を設定し、自オブジェクトを返します。
	 *
	 * @param requestId リクエスト識別子
	 * @return 自オブジェクト
	 */
	public NiftyDescribeNatTablesResult withRequestId(String requestId) {
		setRequestId(requestId);
		return this;
	}

	/**
	 * NATテーブル情報リストを取得します。
	 *
	 * @return NATテーブル情報リスト
	 */
	public List<NatTableSet> getNatTables() {
		return natTables;
	}

	/**
	 * NATテーブル情報リストを設定します。
	 *
	 * @param natTables NATテーブル情報リスト
	 */
	public void setNatTables(List<NatTableSet> natTables) {
		this.natTables = natTables;
	}

	/**
	 * NATテーブル情報の配列を設定し、自オブジェクトを返します。
	 *
	 * @param natTables NATテーブル情報の配列
	 * @return 自オブジェクト
	 */
	public NiftyDescribeNatTablesResult withNatTables(NatTableSet ... natTables) {
		if (this.natTables == null) this.natTables = new ArrayList<NatTableSet>();
		for (NatTableSet natTable : natTables) {
			getNatTables().add(natTable);
		}
		return this;
	}

	/**
	 * NATテーブル情報リストを設定し、自オブジェクトを返します。
	 *
	 * @param natTables NATテーブル情報リスト
	 * @return 自オブジェクト
	 */
	public NiftyDescribeNatTablesResult withNatTables(Collection<NatTableSet> natTables) {
		if (this.natTables == null) this.natTables = new ArrayList<NatTableSet>();
		if (natTables != null) {
			getNatTables().addAll(natTables);
		}
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[requestId=");
		builder.append(requestId);
		builder.append(", natTables=");
		builder.append(natTables);
		builder.append("]");
		return builder.toString();
	}
}
