/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.nattable.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftyDeleteNatRuleリクエストクラス。<br />
 * このクラスはNiftyDeleteNatRuleへのリクエストを構築します。
 *
 */
@Action("NiftyDeleteNatRule")
public class NiftyDeleteNatRuleRequest implements Request {

	/** NATテーブルID */
	private String natTableId;

	/** NATタイプ */
	private String natType;

	/** ルール番号 */
	private String ruleNumber;

	/**
	 * デフォルトコンストラクタ。
	 */
	public NiftyDeleteNatRuleRequest() {
	}

	/**
	 * NATテーブルID,NATタイプ,ルール番号を指定し、NiftyDeleteNatRuleRequestを構築します。
	 *
	 * @param natTableId NATテーブルID
	 * @param natType NATタイプ
	 * @param ruleNumber ルール番号
	 */
	public NiftyDeleteNatRuleRequest(String natTableId, String natType, String ruleNumber) {
		this.natTableId = natTableId;
		this.natType = natType;
		this.ruleNumber = ruleNumber;
	}

	/**
	 * NATテーブルIDを取得します。
	 *
	 * @return NATテーブルID
	 */
	@Query(name="NatTableId", require=true)
	public String getNatTableId() {
		return natTableId;
	}

	/**
	 * NATテーブルIDを設定します。
	 *
	 * @param natTableId NATテーブルID
	 */
	public void setNatTableId(String natTableId) {
		this.natTableId = natTableId;
	}

	/**
	 * NATテーブルIDを設定し、自オブジェクトを返します。
	 *
	 * @param natTableId NATテーブルID
	 * @return 自オブジェクト
	 */
	public NiftyDeleteNatRuleRequest withNatTableId(String natTableId) {
		setNatTableId(natTableId);
		return this;
	}

	/**
	 * NATタイプを取得します。
	 *
	 * @return NATタイプ
	 */
	@Query(name="NatType", require=true)
	public String getNatType() {
		return natType;
	}

	/**
	 * NATタイプを設定します。
	 *
	 * @param natType NATタイプ
	 */
	public void setNatType(String natType) {
		this.natType = natType;
	}

	/**
	 * NATタイプを設定し、自オブジェクトを返します。
	 *
	 * @param natType NATタイプ
	 * @return 自オブジェクト
	 */
	public NiftyDeleteNatRuleRequest withNatType(String natType) {
		setNatType(natType);
		return this;
	}

	/**
	 * ルール番号を取得します。
	 *
	 * @return ルール番号
	 */
	@Query(name="RuleNumber", require=true)
	public String getRuleNumber() {
		return ruleNumber;
	}

	/**
	 * ルール番号を設定します。
	 *
	 * @param ruleNumber ルール番号
	 */
	public void setRuleNumber(String ruleNumber) {
		this.ruleNumber = ruleNumber;
	}

	/**
	 * ルール番号を設定し、自オブジェクトを返します。
	 *
	 * @param ruleNumber ルール番号
	 * @return 自オブジェクト
	 */
	public NiftyDeleteNatRuleRequest withRuleNumber(String ruleNumber) {
		setRuleNumber(ruleNumber);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[natTableId=");
		builder.append(natTableId);
		builder.append(", natType=");
		builder.append(natType);
		builder.append(", ruleNumber=");
		builder.append(ruleNumber);
		builder.append("]");
		return builder.toString();
	}
}
