/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.nattable.model;

import com.nifty.cloud.sdk.Result;
import com.nifty.cloud.sdk.nattable.model.transform.NiftyCreateNatTableResultConverter;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;

/**
 * NiftyCreateNatTable処理結果クラス。<br />
 * このクラスはNiftyCreateNatTableのレスポンスを格納します。
 */
@XStreamAlias("NiftyCreateNatTableResponse")
@XStreamConverter(NiftyCreateNatTableResultConverter.class)
public class NiftyCreateNatTableResult extends Result {

	/** リクエスト識別子 */
	private String requestId;

	/** NATテーブル情報 */
	private NatTable natTable;

	/**
	 * リクエスト識別子を取得します。
	 *
	 * @return リクエスト識別子
	 */
	public String getRequestId() {
		return requestId;
	}

	/**
	 * リクエスト識別子を設定します。
	 *
	 * @param requestId リクエスト識別子
	 */
	public void setRequestId(String requestId) {
		this.requestId = requestId;
	}

	/**
	 * リクエスト識別子を設定し、自オブジェクトを返します。
	 *
	 * @param requestId リクエスト識別子
	 * @return 自オブジェクト
	 */
	public NiftyCreateNatTableResult withRequestId(String requestId) {
		setRequestId(requestId);
		return this;
	}

	/**
	 * NATテーブル情報を取得します。
	 *
	 * @return NATテーブル情報
	 */
	public NatTable getNatTable() {
		return natTable;
	}

	/**
	 * NATテーブル情報を設定します。
	 *
	 * @param natTable NATテーブル情報
	 */
	public void setNatTable(NatTable natTable) {
		this.natTable = natTable;
	}

	/**
	 * NATテーブル情報を設定し、自オブジェクトを返します。
	 *
	 * @param natTable NATテーブル情報
	 * @return 自オブジェクト
	 */
	public NiftyCreateNatTableResult withNatTable(NatTable natTable) {
		setNatTable(natTable);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[requestId=");
		builder.append(requestId);
		builder.append(", natTable=");
		builder.append(natTable);
		builder.append("]");
		return builder.toString();
	}
}
