/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.nattable.model;

import com.nifty.cloud.sdk.Result;
import com.nifty.cloud.sdk.nattable.model.transform.NiftyCreateNatRuleResultConverter;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;

/**
 * NiftyCreateNatRule処理結果クラス。<br />
 * このクラスはNiftyCreateNatRuleのレスポンスを格納します。
 */
@XStreamAlias("NiftyCreateNatRuleResponse")
@XStreamConverter(NiftyCreateNatRuleResultConverter.class)
public class NiftyCreateNatRuleResult extends Result {

	/** リクエスト識別子 */
	private String requestId;

	/** NATテーブルID */
	private String natTableId;

	/** NATルール情報 */
	private NatRule natRule;

	/**
	 * リクエスト識別子を取得します。
	 *
	 * @return リクエスト識別子
	 */
	public String getRequestId() {
		return requestId;
	}

	/**
	 * リクエスト識別子を設定します。
	 *
	 * @param requestId リクエスト識別子
	 */
	public void setRequestId(String requestId) {
		this.requestId = requestId;
	}

	/**
	 * リクエスト識別子を設定し、自オブジェクトを返します。
	 *
	 * @param requestId リクエスト識別子
	 * @return 自オブジェクト
	 */
	public NiftyCreateNatRuleResult withRequestId(String requestId) {
		setRequestId(requestId);
		return this;
	}

	/**
	 * NATテーブルIDを取得します。
	 *
	 * @return NATテーブルID
	 */
	public String getNatTableId() {
		return natTableId;
	}

	/**
	 * NATテーブルIDを設定します。
	 *
	 * @param natTableId NATテーブルID
	 */
	public void setNatTableId(String natTableId) {
		this.natTableId = natTableId;
	}

	/**
	 * NATテーブルIDを設定し、自オブジェクトを返します。
	 *
	 * @param natTableId NATテーブルID
	 * @return 自オブジェクト
	 */
	public NiftyCreateNatRuleResult withNatTableId(String natTableId) {
		setNatTableId(natTableId);
		return this;
	}

	/**
	 * NATルール情報を取得します。
	 *
	 * @return NATルール情報
	 */
	public NatRule getNatRule() {
		return natRule;
	}

	/**
	 * NATルール情報を設定します。
	 *
	 * @param natRule NATルール情報
	 */
	public void setNatRule(NatRule natRule) {
		this.natRule = natRule;
	}

	/**
	 * NATルール情報を設定し、自オブジェクトを返します。
	 *
	 * @param natRule NATルール情報
	 * @return 自オブジェクト
	 */
	public NiftyCreateNatRuleResult withNatRule(NatRule natRule) {
		setNatRule(natRule);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[requestId=");
		builder.append(requestId);
		builder.append(", natTableId=");
		builder.append(natTableId);
		builder.append(", natRule=");
		builder.append(natRule);
		builder.append("]");
		return builder.toString();
	}
}
