/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.nattable.model;

import com.nifty.cloud.sdk.annotation.Query;

/**
 * NATテーブル情報クラス。<br />
 * このクラスはNATテーブル情報を格納します。
 *
 */
public class NatTableIdSet {

	/** NATテーブルID */
	private String natTableId;

	/**
	 * NATテーブルIDを取得します。
	 *
	 * @return NATテーブルID
	 */
	@Query(name="NatTableId", reverseSequence=true)
	public String getNatTableId() {
		return natTableId;
	}

	/**
	 * NATテーブルIDを設定します。
	 *
	 * @param natTableId NATテーブルID
	 */
	public void setNatTableId(String natTableId) {
		this.natTableId = natTableId;
	}

	/**
	 * NATテーブルIDを設定し、自オブジェクトを返します。
	 *
	 * @param natTableId NATテーブルID
	 * @return 自オブジェクト
	 */
	public NatTableIdSet withNatTableId(String natTableId) {
		setNatTableId(natTableId);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[natTableId=");
		builder.append(natTableId);
		builder.append("]");
		return builder.toString();
	}
}
