/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.nattable.model;

/**
 * NATテーブル適用情報クラス。<br />
 * このクラスはNATテーブル適用情報を格納します。
 *
 */
public class NatTableAssociation {

	/** NATテーブル適用ID */
	private String associationId;

	/** NATテーブルID */
	private String natTableId;

	/** ルーターユニークID */
	private String routerId;

	/** ルーター名 */
	private String routerName;

	/**
	 * NATテーブル適用IDを取得します。
	 *
	 * @return NATテーブル適用ID
	 */
	public String getAssociationId() {
		return associationId;
	}

	/**
	 * NATテーブル適用IDを設定します。
	 *
	 * @param associationId NATテーブル適用ID
	 */
	public void setAssociationId(String associationId) {
		this.associationId = associationId;
	}

	/**
	 * NATテーブル適用IDを設定し、自オブジェクトを返します。
	 *
	 * @param associationId NATテーブル適用ID
	 * @return 自オブジェクト
	 */
	public NatTableAssociation withAssociationId(String associationId) {
		setAssociationId(associationId);
		return this;
	}

	/**
	 * NATテーブルIDを取得します。
	 *
	 * @return NATテーブルID
	 */
	public String getNatTableId() {
		return natTableId;
	}

	/**
	 * NATテーブルIDを設定します。
	 *
	 * @param natTableId NATテーブルID
	 */
	public void setNatTableId(String natTableId) {
		this.natTableId = natTableId;
	}

	/**
	 * NATテーブルIDを設定し、自オブジェクトを返します。
	 *
	 * @param natTableId NATテーブルID
	 * @return 自オブジェクト
	 */
	public NatTableAssociation withNatTableId(String natTableId) {
		setNatTableId(natTableId);
		return this;
	}

	/**
	 * ルーターユニークIDを取得します。
	 *
	 * @return ルーターユニークID
	 */
	public String getRouterId() {
		return routerId;
	}

	/**
	 * ルーターユニークIDを設定します。
	 *
	 * @param routerId ルーターユニークID
	 */
	public void setRouterId(String routerId) {
		this.routerId = routerId;
	}

	/**
	 * ルーターユニークIDを設定し、自オブジェクトを返します。
	 *
	 * @param routerId ルーターユニークID
	 * @return 自オブジェクト
	 */
	public NatTableAssociation withRouterId(String routerId) {
		setRouterId(routerId);
		return this;
	}

	/**
	 * ルーター名を取得します。
	 *
	 * @return ルーター名
	 */
	public String getRouterName() {
		return routerName;
	}

	/**
	 * ルーター名を設定します。
	 *
	 * @param routerName ルーター名
	 */
	public void setRouterName(String routerName) {
		this.routerName = routerName;
	}

	/**
	 * ルーター名を設定し、自オブジェクトを返します。
	 *
	 * @param routerName ルーター名
	 * @return 自オブジェクト
	 */
	public NatTableAssociation withRouterName(String routerName) {
		setRouterName(routerName);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[associationId=");
		builder.append(associationId);
		builder.append(", natTableId=");
		builder.append(natTableId);
		builder.append(", routerId=");
		builder.append(routerId);
		builder.append(", routerName=");
		builder.append(routerName);
		builder.append("]");
		return builder.toString();
	}
}
