/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.nattable.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * NATテーブル情報クラス。<br />
 * このクラスはNATテーブル情報を格納します。
 *
 */
public class NatTable {

	/** NATテーブルID */
	private String natTableId;

	/** リソースに設定されているタグ情報 */
	private List<Tag> tagSet;

	/**
	 * NATテーブルIDを取得します。
	 *
	 * @return NATテーブルID
	 */
	public String getNatTableId() {
		return natTableId;
	}

	/**
	 * NATテーブルIDを設定します。
	 *
	 * @param natTableId NATテーブルID
	 */
	public void setNatTableId(String natTableId) {
		this.natTableId = natTableId;
	}

	/**
	 * NATテーブルIDを設定し、自オブジェクトを返します。
	 *
	 * @param natTableId NATテーブルID
	 * @return 自オブジェクト
	 */
	public NatTable withNatTableId(String natTableId) {
		setNatTableId(natTableId);
		return this;
	}

	/**
	 * リソースに設定されているタグ情報を取得します。
	 *
	 * @return リソースに設定されているタグ情報
	 */
	public List<Tag> getTagSet() {
		return tagSet;
	}

	/**
	 * リソースに設定されているタグ情報を設定します。
	 *
	 * @param tagSet リソースに設定されているタグ情報
	 */
	public void setTagSet(List<Tag> tagSet) {
		this.tagSet = tagSet;
	}

	/**
	 * リソースに設定されているタグ情報の配列を設定し、自オブジェクトを返します。
	 *
	 * @param tagSet リソースに設定されているタグ情報の配列
	 * @return 自オブジェクト
	 */
	public NatTable withTagSet(Tag ... tagSet) {
		if (this.tagSet == null) this.tagSet = new ArrayList<Tag>();
		for (Tag tag : tagSet) {
			getTagSet().add(tag);
		}
		return this;
	}

	/**
	 * リソースに設定されているタグ情報リストを設定し、自オブジェクトを返します。
	 *
	 * @param tagSet リソースに設定されているタグ情報リスト
	 * @return 自オブジェクト
	 */
	public NatTable withTagSet(Collection<Tag> tagSet) {
		if (this.tagSet == null) this.tagSet = new ArrayList<Tag>();
		if (tagSet != null) {
			getTagSet().addAll(tagSet);
		}
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[natTableId=");
		builder.append(natTableId);
		builder.append(", tagSet=");
		builder.append(tagSet);
		builder.append("]");
		return builder.toString();
	}
}
