/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.nattable.model;

import com.nifty.cloud.sdk.annotation.Query;

/**
 * NATルール情報クラス。<br />
 * このクラスはNATルール情報を格納します。
 *
 */
public class NatRule {

	/** NATタイプ */
	private String natType;

	/** ルール番号 */
	private String ruleNumber;

	/** NATルールのメモ */
	private String description;

	/** プロトコル */
	private String protocol;

	/** NATトラフィックのアウトバウンドインターフェイス（snatの場合のみ） */
	private NetworkInterface outboundInterface;

	/** NATトラフィックのインバウンドインターフェイス（dnatの場合のみ） */
	private NetworkInterface inboundInterface;

	/** 送信先情報 */
	private Destination destination;

	/** 送信元情報 */
	private Source source;

	/** 変換情報 */
	private Translation translation;

	/**
	 * NATタイプを取得します。
	 *
	 * @return NATタイプ
	 */
	@Query(name="NatType", require=true)
	public String getNatType() {
		return natType;
	}

	/**
	 * NATタイプを設定します。
	 *
	 * @param natType NATタイプ
	 */
	public void setNatType(String natType) {
		this.natType = natType;
	}

	/**
	 * NATタイプを設定し、自オブジェクトを返します。
	 *
	 * @param natType NATタイプ
	 * @return 自オブジェクト
	 */
	public NatRule withNatType(String natType) {
		setNatType(natType);
		return this;
	}

	/**
	 * ルール番号を取得します。
	 *
	 * @return ルール番号
	 */
	@Query(name="RuleNumber", require=true)
	public String getRuleNumber() {
		return ruleNumber;
	}

	/**
	 * ルール番号を設定します。
	 *
	 * @param ruleNumber ルール番号
	 */
	public void setRuleNumber(String ruleNumber) {
		this.ruleNumber = ruleNumber;
	}

	/**
	 * ルール番号を設定し、自オブジェクトを返します。
	 *
	 * @param ruleNumber ルール番号
	 * @return 自オブジェクト
	 */
	public NatRule withRuleNumber(String ruleNumber) {
		setRuleNumber(ruleNumber);
		return this;
	}

	/**
	 * NATルールのメモを取得します。
	 *
	 * @return NATルールのメモ
	 */
	@Query(name="Description")
	public String getDescription() {
		return description;
	}

	/**
	 * NATルールのメモを設定します。
	 *
	 * @param description NATルールのメモ
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * NATルールのメモを設定し、自オブジェクトを返します。
	 *
	 * @param description NATルールのメモ
	 * @return 自オブジェクト
	 */
	public NatRule withDescription(String description) {
		setDescription(description);
		return this;
	}

	/**
	 * プロトコルを取得します。
	 *
	 * @return プロトコル
	 */
	@Query(name="Protocol", require=true)
	public String getProtocol() {
		return protocol;
	}

	/**
	 * プロトコルを設定します。
	 *
	 * @param protocol プロトコル
	 */
	public void setProtocol(String protocol) {
		this.protocol = protocol;
	}

	/**
	 * プロトコルを設定し、自オブジェクトを返します。
	 *
	 * @param protocol プロトコル
	 * @return 自オブジェクト
	 */
	public NatRule withProtocol(String protocol) {
		setProtocol(protocol);
		return this;
	}

	/**
	 * NATトラフィックのアウトバウンドインターフェイス（snatの場合のみ）を取得します。
	 *
	 * @return NATトラフィックのアウトバウンドインターフェイス（snatの場合のみ）
	 */
	@Query(name="OutboundInterface")
	public NetworkInterface getOutboundInterface() {
		return outboundInterface;
	}

	/**
	 * NATトラフィックのアウトバウンドインターフェイス（snatの場合のみ）を設定します。
	 *
	 * @param outboundInterface NATトラフィックのアウトバウンドインターフェイス（snatの場合のみ）
	 */
	public void setOutboundInterface(NetworkInterface outboundInterface) {
		this.outboundInterface = outboundInterface;
	}

	/**
	 * NATトラフィックのアウトバウンドインターフェイス（snatの場合のみ）を設定し、自オブジェクトを返します。
	 *
	 * @param outboundInterface NATトラフィックのアウトバウンドインターフェイス（snatの場合のみ）
	 * @return 自オブジェクト
	 */
	public NatRule withOutboundInterface(NetworkInterface outboundInterface) {
		setOutboundInterface(outboundInterface);
		return this;
	}

	/**
	 * NATトラフィックのインバウンドインターフェイス（dnatの場合のみ）を取得します。
	 *
	 * @return NATトラフィックのインバウンドインターフェイス（dnatの場合のみ）
	 */
	@Query(name="InboundInterface")
	public NetworkInterface getInboundInterface() {
		return inboundInterface;
	}

	/**
	 * NATトラフィックのインバウンドインターフェイス（dnatの場合のみ）を設定します。
	 *
	 * @param inboundInterface NATトラフィックのインバウンドインターフェイス（dnatの場合のみ）
	 */
	public void setInboundInterface(NetworkInterface inboundInterface) {
		this.inboundInterface = inboundInterface;
	}

	/**
	 * NATトラフィックのインバウンドインターフェイス（dnatの場合のみ）を設定し、自オブジェクトを返します。
	 *
	 * @param inboundInterface NATトラフィックのインバウンドインターフェイス（dnatの場合のみ）
	 * @return 自オブジェクト
	 */
	public NatRule withInboundInterface(NetworkInterface inboundInterface) {
		setInboundInterface(inboundInterface);
		return this;
	}

	/**
	 * 送信先情報を取得します。
	 *
	 * @return 送信先情報
	 */
	@Query(name="Destination")
	public Destination getDestination() {
		return destination;
	}

	/**
	 * 送信先情報を設定します。
	 *
	 * @param destination 送信先情報
	 */
	public void setDestination(Destination destination) {
		this.destination = destination;
	}

	/**
	 * 送信先情報を設定し、自オブジェクトを返します。
	 *
	 * @param destination 送信先情報
	 * @return 自オブジェクト
	 */
	public NatRule withDestination(Destination destination) {
		setDestination(destination);
		return this;
	}

	/**
	 * 送信元情報を取得します。
	 *
	 * @return 送信元情報
	 */
	@Query(name="Source")
	public Source getSource() {
		return source;
	}

	/**
	 * 送信元情報を設定します。
	 *
	 * @param source 送信元情報
	 */
	public void setSource(Source source) {
		this.source = source;
	}

	/**
	 * 送信元情報を設定し、自オブジェクトを返します。
	 *
	 * @param source 送信元情報
	 * @return 自オブジェクト
	 */
	public NatRule withSource(Source source) {
		setSource(source);
		return this;
	}

	/**
	 * 変換情報を取得します。
	 *
	 * @return 変換情報
	 */
	@Query(name="Translation")
	public Translation getTranslation() {
		return translation;
	}

	/**
	 * 変換情報を設定します。
	 *
	 * @param translation 変換情報
	 */
	public void setTranslation(Translation translation) {
		this.translation = translation;
	}

	/**
	 * 変換情報を設定し、自オブジェクトを返します。
	 *
	 * @param translation 変換情報
	 * @return 自オブジェクト
	 */
	public NatRule withTranslation(Translation translation) {
		setTranslation(translation);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[natType=");
		builder.append(natType);
		builder.append(", ruleNumber=");
		builder.append(ruleNumber);
		builder.append(", description=");
		builder.append(description);
		builder.append(", protocol=");
		builder.append(protocol);
		builder.append(", outboundInterface=");
		builder.append(outboundInterface);
		builder.append(", inboundInterface=");
		builder.append(inboundInterface);
		builder.append(", destination=");
		builder.append(destination);
		builder.append(", source=");
		builder.append(source);
		builder.append(", translation=");
		builder.append(translation);
		builder.append("]");
		return builder.toString();
	}
}
