/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.nattable.model;

import com.nifty.cloud.sdk.annotation.Query;

/**
 * 送信先情報クラス。<br />
 * このクラスは送信先情報を格納します。
 *
 */
public class Destination {

	/** ポート */
	private Integer port;

	/**
	 * ポートを取得します。
	 *
	 * @return ポート
	 */
	@Query(name="Port")
	public Integer getPort() {
		return port;
	}

	/**
	 * ポートを設定します。
	 *
	 * @param port ポート
	 */
	public void setPort(Integer port) {
		this.port = port;
	}

	/**
	 * ポートを設定し、自オブジェクトを返します。
	 *
	 * @param port ポート
	 * @return 自オブジェクト
	 */
	public Destination withPort(Integer port) {
		setPort(port);
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[port=");
		builder.append(port);
		builder.append("]");
		return builder.toString();
	}
}
