/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.nattable;

import com.nifty.cloud.sdk.BaseClient;
import com.nifty.cloud.sdk.ClientConfiguration;
import com.nifty.cloud.sdk.auth.Credentials;
import com.nifty.cloud.sdk.nattable.model.NiftyAssociateNatTableRequest;
import com.nifty.cloud.sdk.nattable.model.NiftyAssociateNatTableResult;
import com.nifty.cloud.sdk.nattable.model.NiftyCreateNatRuleRequest;
import com.nifty.cloud.sdk.nattable.model.NiftyCreateNatRuleResult;
import com.nifty.cloud.sdk.nattable.model.NiftyCreateNatTableRequest;
import com.nifty.cloud.sdk.nattable.model.NiftyCreateNatTableResult;
import com.nifty.cloud.sdk.nattable.model.NiftyDeleteNatRuleRequest;
import com.nifty.cloud.sdk.nattable.model.NiftyDeleteNatRuleResult;
import com.nifty.cloud.sdk.nattable.model.NiftyDeleteNatTableRequest;
import com.nifty.cloud.sdk.nattable.model.NiftyDeleteNatTableResult;
import com.nifty.cloud.sdk.nattable.model.NiftyDescribeNatTablesRequest;
import com.nifty.cloud.sdk.nattable.model.NiftyDescribeNatTablesResult;
import com.nifty.cloud.sdk.nattable.model.NiftyDisassociateNatTableRequest;
import com.nifty.cloud.sdk.nattable.model.NiftyDisassociateNatTableResult;
import com.nifty.cloud.sdk.nattable.model.NiftyReplaceNatRuleRequest;
import com.nifty.cloud.sdk.nattable.model.NiftyReplaceNatRuleResult;
import com.nifty.cloud.sdk.nattable.model.NiftyReplaceNatTableAssociationRequest;
import com.nifty.cloud.sdk.nattable.model.NiftyReplaceNatTableAssociationResult;

/**
 * NIFCLOUD API クライアント　具象クラス。
 * NATテーブルカテゴリ クライアント。<br />
 * NATテーブル カテゴリの同期クライアントの具象クラスです。
 *
 */
public class NiftyNatTableClient extends BaseClient implements NiftyNatTable {

	/**
	 * 認証情報を指定し、NATテーブルカテゴリクライアントを構築します。
	 *
	 * @param credential 認証情報
	 */
	public NiftyNatTableClient(Credentials credential) {
		super(credential, new ClientConfiguration());
	}

	/**
	 * 認証情報、クライアント設定を指定し、NATテーブルカテゴリクライアントを構築します。
	 *
	 * @param credential 認証情報
	 * @param configuration クライアント設定
	 */
	public NiftyNatTableClient(Credentials credential, ClientConfiguration configuration) {
		super(credential, configuration);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.nattable.NiftyNatTable#niftyCreateNatTable(com.nifty.cloud.sdk.nattable.model.NiftyCreateNatTableRequest)
	 */
	@Override
	public NiftyCreateNatTableResult niftyCreateNatTable(NiftyCreateNatTableRequest request) {
		return (NiftyCreateNatTableResult) client.execute(request, NiftyCreateNatTableResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.nattable.NiftyNatTable#niftyDeleteNatTable(com.nifty.cloud.sdk.nattable.model.NiftyDeleteNatTableRequest)
	 */
	@Override
	public NiftyDeleteNatTableResult niftyDeleteNatTable(NiftyDeleteNatTableRequest request) {
		return (NiftyDeleteNatTableResult) client.execute(request, NiftyDeleteNatTableResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.nattable.NiftyNatTable#niftyDescribeNatTables(com.nifty.cloud.sdk.nattable.model.NiftyDescribeNatTablesRequest)
	 */
	@Override
	public NiftyDescribeNatTablesResult niftyDescribeNatTables(NiftyDescribeNatTablesRequest request) {
		return (NiftyDescribeNatTablesResult) client.execute(request, NiftyDescribeNatTablesResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.nattable.NiftyNatTable#niftyAssociateNatTable(com.nifty.cloud.sdk.nattable.model.NiftyAssociateNatTableRequest)
	 */
	@Override
	public NiftyAssociateNatTableResult niftyAssociateNatTable(NiftyAssociateNatTableRequest request) {
		return (NiftyAssociateNatTableResult) client.execute(request, NiftyAssociateNatTableResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.nattable.NiftyNatTable#niftyDisassociateNatTable(com.nifty.cloud.sdk.nattable.model.NiftyDisassociateNatTableRequest)
	 */
	@Override
	public NiftyDisassociateNatTableResult niftyDisassociateNatTable(NiftyDisassociateNatTableRequest request) {
		return (NiftyDisassociateNatTableResult) client.execute(request, NiftyDisassociateNatTableResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.nattable.NiftyNatTable#niftyReplaceNatTableAssociation(com.nifty.cloud.sdk.nattable.model.NiftyReplaceNatTableAssociationRequest)
	 */
	@Override
	public NiftyReplaceNatTableAssociationResult niftyReplaceNatTableAssociation(NiftyReplaceNatTableAssociationRequest request) {
		return (NiftyReplaceNatTableAssociationResult) client.execute(request, NiftyReplaceNatTableAssociationResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.nattable.NiftyNatTable#niftyCreateNatRule(com.nifty.cloud.sdk.nattable.model.NiftyCreateNatRuleRequest)
	 */
	@Override
	public NiftyCreateNatRuleResult niftyCreateNatRule(NiftyCreateNatRuleRequest request) {
		return (NiftyCreateNatRuleResult) client.execute(request, NiftyCreateNatRuleResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.nattable.NiftyNatTable#niftyDeleteNatRule(com.nifty.cloud.sdk.nattable.model.NiftyDeleteNatRuleRequest)
	 */
	@Override
	public NiftyDeleteNatRuleResult niftyDeleteNatRule(NiftyDeleteNatRuleRequest request) {
		return (NiftyDeleteNatRuleResult) client.execute(request, NiftyDeleteNatRuleResult.class);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.nattable.NiftyNatTable#niftyReplaceNatRule(com.nifty.cloud.sdk.nattable.model.NiftyReplaceNatRuleRequest)
	 */
	@Override
	public NiftyReplaceNatRuleResult niftyReplaceNatRule(NiftyReplaceNatRuleRequest request) {
		return (NiftyReplaceNatRuleResult) client.execute(request, NiftyReplaceNatRuleResult.class);
	}
}