/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.nattable;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

import com.nifty.cloud.sdk.ClientConfiguration;
import com.nifty.cloud.sdk.auth.Credentials;
import com.nifty.cloud.sdk.nattable.model.NiftyAssociateNatTableRequest;
import com.nifty.cloud.sdk.nattable.model.NiftyAssociateNatTableResult;
import com.nifty.cloud.sdk.nattable.model.NiftyCreateNatRuleRequest;
import com.nifty.cloud.sdk.nattable.model.NiftyCreateNatRuleResult;
import com.nifty.cloud.sdk.nattable.model.NiftyCreateNatTableRequest;
import com.nifty.cloud.sdk.nattable.model.NiftyCreateNatTableResult;
import com.nifty.cloud.sdk.nattable.model.NiftyDeleteNatRuleRequest;
import com.nifty.cloud.sdk.nattable.model.NiftyDeleteNatRuleResult;
import com.nifty.cloud.sdk.nattable.model.NiftyDeleteNatTableRequest;
import com.nifty.cloud.sdk.nattable.model.NiftyDeleteNatTableResult;
import com.nifty.cloud.sdk.nattable.model.NiftyDescribeNatTablesRequest;
import com.nifty.cloud.sdk.nattable.model.NiftyDescribeNatTablesResult;
import com.nifty.cloud.sdk.nattable.model.NiftyDisassociateNatTableRequest;
import com.nifty.cloud.sdk.nattable.model.NiftyDisassociateNatTableResult;
import com.nifty.cloud.sdk.nattable.model.NiftyReplaceNatRuleRequest;
import com.nifty.cloud.sdk.nattable.model.NiftyReplaceNatRuleResult;
import com.nifty.cloud.sdk.nattable.model.NiftyReplaceNatTableAssociationRequest;
import com.nifty.cloud.sdk.nattable.model.NiftyReplaceNatTableAssociationResult;

/**
 * NIFCLOUD API 非同期クライアント 具象クラス。
 * NATテーブルカテゴリクライアント。<br />
 * NATテーブル カテゴリの非同期クライアントの具象クラスです。
 *
 */
public class NiftyNatTableAsyncClient extends NiftyNatTableClient implements NiftyNatTableAsync {


	/** 非同期タスク実行クラス. */
	protected ExecutorService executorService = null;

	/**
	 * 認証情報を指定し、NATテーブルカテゴリクライアントを構築します。
	 *
	 * @param credential 認証情報
	 */
	public NiftyNatTableAsyncClient(Credentials credential) {
		this(credential, Executors.newCachedThreadPool());
	}

	/**
	 * 認証情報、クライアント設定を指定し、NATテーブルカテゴリクライアントを構築します。
	 *
	 * @param credential 認証情報
	 * @param configuration クライアント設定
	 */
	public NiftyNatTableAsyncClient(Credentials credential, ClientConfiguration configuration) {
		this(credential, configuration, Executors.newCachedThreadPool());
	}

	/**
	 * 認証情報,非同期タスク実行クラスを指定し、NATテーブルカテゴリクライアントを構築します。
	 *
	 * @param credential 認証情報
	 * @param executorService 非同期タスク実行クラス
	 */
	public NiftyNatTableAsyncClient(Credentials credential, ExecutorService executorService) {
		super(credential);
		this.executorService = executorService;

	}

	/**
	 * 認証情報、クライアント設定,非同期タスク実行クラスを指定し、NATテーブルカテゴリクライアントを構築します。
	 *
	 * @param credential 認証情報
	 * @param configuration クライアント設定
	 * @param executorService 非同期タスク実行クラス
	 */
	public NiftyNatTableAsyncClient(Credentials credential, ClientConfiguration configuration, ExecutorService executorService) {
		super(credential, configuration);
		this.executorService = executorService;
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.nattable.NiftyNatTableAsync#niftyCreateNatTableAsync(com.nifty.cloud.sdk.nattable.model.NiftyCreateNatTableRequest)
	 */
	@Override
	public Future<NiftyCreateNatTableResult> niftyCreateNatTableAsync(final NiftyCreateNatTableRequest request) {
		return executorService.submit(
				new Callable<NiftyCreateNatTableResult>() {
					@Override
					public NiftyCreateNatTableResult call() {
						return niftyCreateNatTable(request);
					}
				}
		);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.nattable.NiftyNatTableAsync#niftyDeleteNatTableAsync(com.nifty.cloud.sdk.nattable.model.NiftyDeleteNatTableRequest)
	 */
	@Override
	public Future<NiftyDeleteNatTableResult> niftyDeleteNatTableAsync(final NiftyDeleteNatTableRequest request) {
		return executorService.submit(
				new Callable<NiftyDeleteNatTableResult>() {
					@Override
					public NiftyDeleteNatTableResult call() {
						return niftyDeleteNatTable(request);
					}
				}
		);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.nattable.NiftyNatTableAsync#niftyDescribeNatTablesAsync(com.nifty.cloud.sdk.nattable.model.NiftyDescribeNatTablesRequest)
	 */
	@Override
	public Future<NiftyDescribeNatTablesResult> niftyDescribeNatTablesAsync(final NiftyDescribeNatTablesRequest request) {
		return executorService.submit(
				new Callable<NiftyDescribeNatTablesResult>() {
					@Override
					public NiftyDescribeNatTablesResult call() {
						return niftyDescribeNatTables(request);
					}
				}
		);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.nattable.NiftyNatTableAsync#niftyAssociateNatTableAsync(com.nifty.cloud.sdk.nattable.model.NiftyAssociateNatTableRequest)
	 */
	@Override
	public Future<NiftyAssociateNatTableResult> niftyAssociateNatTableAsync(final NiftyAssociateNatTableRequest request) {
		return executorService.submit(
				new Callable<NiftyAssociateNatTableResult>() {
					@Override
					public NiftyAssociateNatTableResult call() {
						return niftyAssociateNatTable(request);
					}
				}
		);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.nattable.NiftyNatTableAsync#niftyDisassociateNatTableAsync(com.nifty.cloud.sdk.nattable.model.NiftyDisassociateNatTableRequest)
	 */
	@Override
	public Future<NiftyDisassociateNatTableResult> niftyDisassociateNatTableAsync(final NiftyDisassociateNatTableRequest request) {
		return executorService.submit(
				new Callable<NiftyDisassociateNatTableResult>() {
					@Override
					public NiftyDisassociateNatTableResult call() {
						return niftyDisassociateNatTable(request);
					}
				}
		);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.nattable.NiftyNatTableAsync#niftyReplaceNatTableAssociationAsync(com.nifty.cloud.sdk.nattable.model.NiftyReplaceNatTableAssociationRequest)
	 */
	@Override
	public Future<NiftyReplaceNatTableAssociationResult> niftyReplaceNatTableAssociationAsync(final NiftyReplaceNatTableAssociationRequest request) {
		return executorService.submit(
				new Callable<NiftyReplaceNatTableAssociationResult>() {
					@Override
					public NiftyReplaceNatTableAssociationResult call() {
						return niftyReplaceNatTableAssociation(request);
					}
				}
		);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.nattable.NiftyNatTableAsync#niftyCreateNatRuleAsync(com.nifty.cloud.sdk.nattable.model.NiftyCreateNatRuleRequest)
	 */
	@Override
	public Future<NiftyCreateNatRuleResult> niftyCreateNatRuleAsync(final NiftyCreateNatRuleRequest request) {
		return executorService.submit(
				new Callable<NiftyCreateNatRuleResult>() {
					@Override
					public NiftyCreateNatRuleResult call() {
						return niftyCreateNatRule(request);
					}
				}
		);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.nattable.NiftyNatTableAsync#niftyDeleteNatRuleAsync(com.nifty.cloud.sdk.nattable.model.NiftyDeleteNatRuleRequest)
	 */
	@Override
	public Future<NiftyDeleteNatRuleResult> niftyDeleteNatRuleAsync(final NiftyDeleteNatRuleRequest request) {
		return executorService.submit(
				new Callable<NiftyDeleteNatRuleResult>() {
					@Override
					public NiftyDeleteNatRuleResult call() {
						return niftyDeleteNatRule(request);
					}
				}
		);
	}

	/*
	 * (non-Javadoc)
	 * @see com.nifty.cloud.sdk.nattable.NiftyNatTableAsync#niftyReplaceNatRuleAsync(com.nifty.cloud.sdk.nattable.model.NiftyReplaceNatRuleRequest)
	 */
	@Override
	public Future<NiftyReplaceNatRuleResult> niftyReplaceNatRuleAsync(final NiftyReplaceNatRuleRequest request) {
		return executorService.submit(
				new Callable<NiftyReplaceNatRuleResult>() {
					@Override
					public NiftyReplaceNatRuleResult call() {
						return niftyReplaceNatRule(request);
					}
				}
		);
	}
}