/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.nattable;

import java.util.concurrent.Future;

import com.nifty.cloud.sdk.nattable.model.NiftyAssociateNatTableRequest;
import com.nifty.cloud.sdk.nattable.model.NiftyAssociateNatTableResult;
import com.nifty.cloud.sdk.nattable.model.NiftyCreateNatRuleRequest;
import com.nifty.cloud.sdk.nattable.model.NiftyCreateNatRuleResult;
import com.nifty.cloud.sdk.nattable.model.NiftyCreateNatTableRequest;
import com.nifty.cloud.sdk.nattable.model.NiftyCreateNatTableResult;
import com.nifty.cloud.sdk.nattable.model.NiftyDeleteNatRuleRequest;
import com.nifty.cloud.sdk.nattable.model.NiftyDeleteNatRuleResult;
import com.nifty.cloud.sdk.nattable.model.NiftyDeleteNatTableRequest;
import com.nifty.cloud.sdk.nattable.model.NiftyDeleteNatTableResult;
import com.nifty.cloud.sdk.nattable.model.NiftyDescribeNatTablesRequest;
import com.nifty.cloud.sdk.nattable.model.NiftyDescribeNatTablesResult;
import com.nifty.cloud.sdk.nattable.model.NiftyDisassociateNatTableRequest;
import com.nifty.cloud.sdk.nattable.model.NiftyDisassociateNatTableResult;
import com.nifty.cloud.sdk.nattable.model.NiftyReplaceNatRuleRequest;
import com.nifty.cloud.sdk.nattable.model.NiftyReplaceNatRuleResult;
import com.nifty.cloud.sdk.nattable.model.NiftyReplaceNatTableAssociationRequest;
import com.nifty.cloud.sdk.nattable.model.NiftyReplaceNatTableAssociationResult;

/**
 * NIFCLOUD API 非同期クライアント　インタフェース。
 * NATテーブルカテゴリクライアント。<br />
 * NATテーブル カテゴリの非同期クライアントのインタフェースです。
 *
 */
public interface NiftyNatTableAsync extends NiftyNatTable {

	/**
	 * 非同期でNATテーブルを新規作成します。
	 *
	 * @param request NiftyCreateNatTableリクエスト
	 * @return 非同期処理結果
	 */
	public Future<NiftyCreateNatTableResult> niftyCreateNatTableAsync(NiftyCreateNatTableRequest request);


	/**
	 * 非同期で指定したNATテーブルを削除します。
	 *
	 * @param request NiftyDeleteNatTableリクエスト
	 * @return 非同期処理結果
	 */
	public Future<NiftyDeleteNatTableResult> niftyDeleteNatTableAsync(NiftyDeleteNatTableRequest request);


	/**
	 * 非同期でNATテーブルの情報を取得します。
	 *
	 * @param request NiftyDescribeNatTablesリクエスト
	 * @return 非同期処理結果
	 */
	public Future<NiftyDescribeNatTablesResult> niftyDescribeNatTablesAsync(NiftyDescribeNatTablesRequest request);


	/**
	 * 非同期で指定したNATテーブルを指定したルーターに設定します。
	 *
	 * @param request NiftyAssociateNatTableリクエスト
	 * @return 非同期処理結果
	 */
	public Future<NiftyAssociateNatTableResult> niftyAssociateNatTableAsync(NiftyAssociateNatTableRequest request);


	/**
	 * 非同期で指定したNATテーブルをルーターから解除します。
	 *
	 * @param request NiftyDisassociateNatTableリクエスト
	 * @return 非同期処理結果
	 */
	public Future<NiftyDisassociateNatTableResult> niftyDisassociateNatTableAsync(NiftyDisassociateNatTableRequest request);


	/**
	 * 非同期でルーターに適用されたNATテーブルを解除し、指定したNATテーブルに入れ替えます。
	 *
	 * @param request NiftyReplaceNatTableAssociationリクエスト
	 * @return 非同期処理結果
	 */
	public Future<NiftyReplaceNatTableAssociationResult> niftyReplaceNatTableAssociationAsync(NiftyReplaceNatTableAssociationRequest request);


	/**
	 * 非同期でNATテーブルに適用するNATルール情報を新規作成します。
	 *
	 * @param request NiftyCreateNatRuleリクエスト
	 * @return 非同期処理結果
	 */
	public Future<NiftyCreateNatRuleResult> niftyCreateNatRuleAsync(NiftyCreateNatRuleRequest request);


	/**
	 * 非同期でNATテーブルに適用されたNATルール情報を削除します。
	 *
	 * @param request NiftyDeleteNatRuleリクエスト
	 * @return 非同期処理結果
	 */
	public Future<NiftyDeleteNatRuleResult> niftyDeleteNatRuleAsync(NiftyDeleteNatRuleRequest request);


	/**
	 * 非同期でNATテーブルに適用されたNATルール情報を削除し、指定したNATルール情報に入れ替えます。
	 *
	 * @param request NiftyReplaceNatRuleリクエスト
	 * @return 非同期処理結果
	 */
	public Future<NiftyReplaceNatRuleResult> niftyReplaceNatRuleAsync(NiftyReplaceNatRuleRequest request);

}