/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.nattable;

import com.nifty.cloud.sdk.nattable.model.NiftyAssociateNatTableRequest;
import com.nifty.cloud.sdk.nattable.model.NiftyAssociateNatTableResult;
import com.nifty.cloud.sdk.nattable.model.NiftyCreateNatRuleRequest;
import com.nifty.cloud.sdk.nattable.model.NiftyCreateNatRuleResult;
import com.nifty.cloud.sdk.nattable.model.NiftyCreateNatTableRequest;
import com.nifty.cloud.sdk.nattable.model.NiftyCreateNatTableResult;
import com.nifty.cloud.sdk.nattable.model.NiftyDeleteNatRuleRequest;
import com.nifty.cloud.sdk.nattable.model.NiftyDeleteNatRuleResult;
import com.nifty.cloud.sdk.nattable.model.NiftyDeleteNatTableRequest;
import com.nifty.cloud.sdk.nattable.model.NiftyDeleteNatTableResult;
import com.nifty.cloud.sdk.nattable.model.NiftyDescribeNatTablesRequest;
import com.nifty.cloud.sdk.nattable.model.NiftyDescribeNatTablesResult;
import com.nifty.cloud.sdk.nattable.model.NiftyDisassociateNatTableRequest;
import com.nifty.cloud.sdk.nattable.model.NiftyDisassociateNatTableResult;
import com.nifty.cloud.sdk.nattable.model.NiftyReplaceNatRuleRequest;
import com.nifty.cloud.sdk.nattable.model.NiftyReplaceNatRuleResult;
import com.nifty.cloud.sdk.nattable.model.NiftyReplaceNatTableAssociationRequest;
import com.nifty.cloud.sdk.nattable.model.NiftyReplaceNatTableAssociationResult;

/**
 * NIFCLOUD API クライアント　インタフェース。
 * NATテーブル カテゴリ クライアント。<br />
 * NATテーブル カテゴリの同期クライアントのインタフェースです。
 *
 */
public interface NiftyNatTable {

	/**
	 * エンドポイントの設定を行います。
	 *
	 * @param endpoint エンドポイント
	 */
	public void setEndpoint(String endpoint);

	/**
	 * NATテーブルを新規作成します。
	 *
	 * @param request NiftyCreateNatTableリクエスト
	 * @return NiftyCreateNatTable処理結果
	 */
	public NiftyCreateNatTableResult niftyCreateNatTable(NiftyCreateNatTableRequest request);

	/**
	 * 指定したNATテーブルを削除します。
	 *
	 * @param request NiftyDeleteNatTableリクエスト
	 * @return NiftyDeleteNatTable処理結果
	 */
	public NiftyDeleteNatTableResult niftyDeleteNatTable(NiftyDeleteNatTableRequest request);

	/**
	 * NATテーブルの情報を取得します。
	 *
	 * @param request NiftyDescribeNatTablesリクエスト
	 * @return NiftyDescribeNatTables処理結果
	 */
	public NiftyDescribeNatTablesResult niftyDescribeNatTables(NiftyDescribeNatTablesRequest request);

	/**
	 * 指定したNATテーブルを指定したルーターに設定します。
	 *
	 * @param request NiftyAssociateNatTableリクエスト
	 * @return NiftyAssociateNatTable処理結果
	 */
	public NiftyAssociateNatTableResult niftyAssociateNatTable(NiftyAssociateNatTableRequest request);

	/**
	 * 指定したNATテーブルをルーターから解除します。
	 *
	 * @param request NiftyDisassociateNatTableリクエスト
	 * @return NiftyDisassociateNatTable処理結果
	 */
	public NiftyDisassociateNatTableResult niftyDisassociateNatTable(NiftyDisassociateNatTableRequest request);

	/**
	 * ルーターに適用されたNATテーブルを解除し、指定したNATテーブルに入れ替えます。
	 *
	 * @param request NiftyReplaceNatTableAssociationリクエスト
	 * @return NiftyReplaceNatTableAssociation処理結果
	 */
	public NiftyReplaceNatTableAssociationResult niftyReplaceNatTableAssociation(NiftyReplaceNatTableAssociationRequest request);

	/**
	 * NATテーブルに適用するNATルール情報を新規作成します。
	 *
	 * @param request NiftyCreateNatRuleリクエスト
	 * @return NiftyCreateNatRule処理結果
	 */
	public NiftyCreateNatRuleResult niftyCreateNatRule(NiftyCreateNatRuleRequest request);

	/**
	 * NATテーブルに適用されたNATルール情報を削除します。
	 *
	 * @param request NiftyDeleteNatRuleリクエスト
	 * @return NiftyDeleteNatRule処理結果
	 */
	public NiftyDeleteNatRuleResult niftyDeleteNatRule(NiftyDeleteNatRuleRequest request);

	/**
	 * NATテーブルに適用されたNATルール情報を削除し、指定したNATルール情報に入れ替えます。
	 *
	 * @param request NiftyReplaceNatRuleリクエスト
	 * @return NiftyReplaceNatRule処理結果
	 */
	public NiftyReplaceNatRuleResult niftyReplaceNatRule(NiftyReplaceNatRuleRequest request);
}