/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model.transform;

import java.util.ArrayList;
import java.util.List;

import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyRegisterPortWithElasticLoadBalancerResult;
import com.nifty.cloud.sdk.multiloadbalancer.model.ResponseListener;
import com.nifty.cloud.sdk.multiloadbalancer.model.ResponseListenerMember;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

/**
 * NiftyRegisterPortWithElasticLoadBalancer変換クラス。<br />
 * このクラスはレスポンスXMLからNiftyRegisterPortWithElasticLoadBalancerResultクラスを生成します。
 */
public class NiftyRegisterPortWithElasticLoadBalancerConverter implements Converter {

    private static final String ELEMENT_LISTENERS = "Listeners";
    private static final String ELEMENT_MEMBER = "member";
    private static final String ELEMENT_PROTOCOL = "Protocol";
    private static final String ELEMENT_ELASTIC_LOAD_BALANCER_PORT = "ElasticLoadBalancerPort";
    private static final String ELEMENT_INSTANCE_PORT = "InstancePort";
    private static final String ELEMENT_BALANCING_TYPE = "BalancingType";
    private static final String ELEMENT_DESCRIPTION = "Description";

    /**
     * 変換可能なクラスか判定します。
     *
     * @param type
     *            クラス
     * @return 変換可能な場合true, 変換不可能な場合false
     *
     * @see com.thoughtworks.xstream.converters.Converter#canConvert(Class)
     */
    @SuppressWarnings("rawtypes")
    @Override
    public boolean canConvert(Class type) {
        return type == NiftyRegisterPortWithElasticLoadBalancerResult.class;
    }

    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer,
        MarshallingContext context) {
        // 処理無し
    }

    /**
     * {@literal
     * NiftyRegisterPortWithElasticLoadBalancerResultをResponseListenerクラスに変換します。}
     *
     * @param reader
     *            XML読込リーダ
     * @param context
     * @return {@literal ResponseListenerオブジェクト}
     *
     * @see com.thoughtworks.xstream.converters.Converter#unmarshal(HierarchicalStreamReader,
     *      UnmarshallingContext)
     */
    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {

        NiftyRegisterPortWithElasticLoadBalancerResult result =
            new NiftyRegisterPortWithElasticLoadBalancerResult();

        ResponseListener listener = new ResponseListener();

        List<ResponseListenerMember> list = new ArrayList<ResponseListenerMember>();

        ResponseListenerMember member = null;

        String name = null;

        reader.moveDown();

        name = reader.getNodeName();

        if (name.equals(ELEMENT_LISTENERS)) {

            while (reader.hasMoreChildren()) {

                reader.moveDown();

                name = reader.getNodeName();

                member = new ResponseListenerMember();

                if (name.equals(ELEMENT_MEMBER)) {

                    while (reader.hasMoreChildren()) {

                        reader.moveDown();

                        name = reader.getNodeName();

                        if (name.equals(ELEMENT_PROTOCOL)) {
                            member.setProtocol(reader.getValue());
                        } else if (name.equals(ELEMENT_ELASTIC_LOAD_BALANCER_PORT)) {
                            member.setElasticLoadBalancerPort(
                                Integer.parseInt(reader.getValue()));
                        } else if (name.equals(ELEMENT_INSTANCE_PORT)) {
                            member.setInstancePort(Integer.parseInt(reader.getValue()));
                        } else if (name.equals(ELEMENT_BALANCING_TYPE)) {
                            member.setBalancingType(reader.getValue());
                        } else if (name.equals(ELEMENT_DESCRIPTION)) {
                            member.setDescription(reader.getValue());
                        }

                        reader.moveUp();

                    }

                    reader.moveUp();

                }

                list.add(member);

            }

            reader.moveUp();

        }

        listener.setMember(list);

        result.setListener(listener);

        return result;

    }

}
