/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model.transform;

import com.nifty.cloud.sdk.Response;
import com.nifty.cloud.sdk.ResponseMetadata;
import com.nifty.cloud.sdk.Result;
import com.nifty.cloud.sdk.multiloadbalancer.model.NiftyDescribeElasticLoadBalancersResult;
import com.thoughtworks.xstream.annotations.XStreamAlias;

/**
 * NiftyDescribeElasticLoadBalancersResponseクラス。<br />
 * このクラスはNiftyDescribeElasticLoadBalancersのレスポンスを格納します。
 */
@XStreamAlias("NiftyDescribeElasticLoadBalancersResponse")
public class NiftyDescribeElasticLoadBalancersResponse implements Response {

    /** レスポンス情報 */
    @XStreamAlias("NiftyDescribeElasticLoadBalancersResult")
    private NiftyDescribeElasticLoadBalancersResult niftyDescribeElasticLoadBalancersResult;

    /** リクエスト情報 */
    @XStreamAlias("ResponseMetadata")
    private ResponseMetadata responseMetadata;

    /**
     * NiftyDescribeElasticLoadBalancersのResultクラスを取得します。
     * 
     * @see com.nifty.cloud.sdk.Response#getResult()
     */
    @Override
    public Result getResult() {
        return niftyDescribeElasticLoadBalancersResult;
    }

    /**
     * レスポンス情報を取得します。
     * 
     * @return レスポンス情報
     */
    public NiftyDescribeElasticLoadBalancersResult getNiftyDescribeElasticLoadBalancersResult() {
        return niftyDescribeElasticLoadBalancersResult;
    }

    /**
     * レスポンス情報を設定します。
     * 
     * @param niftyDescribeElasticLoadBalancersResult
     *            レスポンス情報
     */
    public void setNiftyDescribeElasticLoadBalancersResult(
        NiftyDescribeElasticLoadBalancersResult niftyDescribeElasticLoadBalancersResult) {
        this.niftyDescribeElasticLoadBalancersResult = niftyDescribeElasticLoadBalancersResult;
    }

    /**
     * レスポンス情報を設定し、自オブジェクトを返します。
     * 
     * @param niftyDescribeElasticLoadBalancersResult
     *            レスポンス情報
     * @return 自オブジェクト
     */
    public NiftyDescribeElasticLoadBalancersResponse withNiftyDescribeElasticLoadBalancersResult(
        NiftyDescribeElasticLoadBalancersResult niftyDescribeElasticLoadBalancersResult) {
        setNiftyDescribeElasticLoadBalancersResult(niftyDescribeElasticLoadBalancersResult);
        return this;
    }

    /**
     * リクエスト情報を取得します。
     * 
     * @return リクエスト情報
     */
    public ResponseMetadata getResponseMetadata() {
        return responseMetadata;
    }

    /**
     * リクエスト情報を設定します。
     * 
     * @param responseMetadata
     *            リクエスト情報
     */
    public void setResponseMetadata(ResponseMetadata responseMetadata) {
        this.responseMetadata = responseMetadata;
    }

    /**
     * リクエスト情報を設定し、自オブジェクトを返します。
     * 
     * @param responseMetadata
     *            リクエスト情報
     * @return 自オブジェクト
     */
    public NiftyDescribeElasticLoadBalancersResponse
        withResponseMetadata(ResponseMetadata responseMetadata) {
        setResponseMetadata(responseMetadata);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[niftyDescribeElasticLoadBalancersResult=");
        builder.append(niftyDescribeElasticLoadBalancersResult);

        builder.append(", responseMetadata=");
        builder.append(responseMetadata);

        builder.append("]");

        return builder.toString();
    }

}
