/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model.transform;

import java.util.ArrayList;
import java.util.List;

import com.nifty.cloud.sdk.multiloadbalancer.model.DescriptionMember;
import com.nifty.cloud.sdk.multiloadbalancer.model.ListenerDescribe;
import com.nifty.cloud.sdk.multiloadbalancer.model.NetworkInterface;
import com.nifty.cloud.sdk.multiloadbalancer.model.SystemIpAddress;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

/**
 * NetworkInterfaces変換クラス。<br />
 * このクラスはレスポンスXMLからNetworkInterfaceクラスを生成します。
 */
public class NetworkInterfacesConverter implements Converter {

    private static final String ELEMENT_NETWORK_INTERFACES = "NetworkInterfaces";
    private static final String ELEMENT_MEMBER = "member";
    private static final String ELEMENT_NETWORK_ID = "NetworkId";
    private static final String ELEMENT_NETWORK_NAME = "NetworkName";
    private static final String ELEMENT_DEVICE_INDEX = "DeviceIndex";
    private static final String ELEMENT_IP_ADDRESS = "IpAddress";
    private static final String ELEMENT_IS_VIP_NETWORK = "IsVipNetwork";
    private static final String ELEMENT_DESCRIPTION = "Description";
    private static final String ELEMENT_SYSTEM_IP_ADDRESSES = "SystemIpAddresses";
    private static final String ELEMENT_SYSTEM_IP_ADDRESS = "SystemIpAddress";
    /**
     * 変換可能なクラスか判定します。
     *
     * @param type
     *            クラス
     * @return 変換可能な場合true, 変換不可能な場合false
     *
     * @see com.thoughtworks.xstream.converters.Converter#canConvert(Class)
     */
    @SuppressWarnings("rawtypes")
    @Override
    public boolean canConvert(Class type) {

        Class[] interfaces = type.getInterfaces();

        for (Class i : interfaces) {

            if (i == List.class) {
                return true;
            }

        }

        return false;
    }

    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer,
        MarshallingContext context) {
        // 処理無し
    }

    /**
     * {@literal
     * NetworkInterfacesをList<NetworkInterface>オブジェクトに変換します。}
     *
     * @param reader
     *            XML読込リーダ
     * @param context
     * @return {@literal List<NetworkInterface>オブジェクト}
     *
     * @see com.thoughtworks.xstream.converters.Converter#unmarshal(HierarchicalStreamReader,
     *      UnmarshallingContext)
     */
    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {

        List<NetworkInterface> networkList = new ArrayList<NetworkInterface>();

        NetworkInterface network = null;

        String name = null;

        name = reader.getNodeName();

        if (name.equals(ELEMENT_NETWORK_INTERFACES)) {

            while (reader.hasMoreChildren()) {

                DescriptionMember member = new DescriptionMember();

                ListenerDescribe listener = new ListenerDescribe();

                member.setListenerDescribe(listener);

                reader.moveDown();

                name = reader.getNodeName();

                if (name.equals(ELEMENT_MEMBER)) {

                    network = new NetworkInterface();

                    while (reader.hasMoreChildren()) {

                        reader.moveDown();

                        name = reader.getNodeName();

                        if (name.equals(ELEMENT_NETWORK_ID)) {
                            network.setNetworkId(reader.getValue());
                        } else if (name.equals(ELEMENT_NETWORK_NAME)) {
                            network.setNetworkName(reader.getValue());
                        } else if (name.equals(ELEMENT_DEVICE_INDEX)) {
                            network.setDeviceIndex(Integer.parseInt(reader.getValue()));
                        } else if (name.equals(ELEMENT_IP_ADDRESS)) {
                            network.setIpAddress(reader.getValue());
                        } else if (name.equals(ELEMENT_IS_VIP_NETWORK)) {
                            network.setIsVipNetwork(Boolean.parseBoolean(reader.getValue()));
                        } else if (name.equals(ELEMENT_DESCRIPTION)) {
                            network.setDescription(reader.getValue());
                        } else if (name.equals(ELEMENT_SYSTEM_IP_ADDRESSES)) {

                            while (reader.hasMoreChildren()) {

                                reader.moveDown();

                                name = reader.getNodeName();

                                if (name.equals(ELEMENT_MEMBER)) {

                                    while (reader.hasMoreChildren()) {

                                        reader.moveDown();

                                        name = reader.getNodeName();

                                        if (name.equals(ELEMENT_SYSTEM_IP_ADDRESS)) {
                                            SystemIpAddress systemIpAddress = new SystemIpAddress();
                                            network.withSystemIpAddresses(systemIpAddress.withSystemIpAddress(
                                                    reader.getValue()));
                                        }

                                        reader.moveUp();
                                    }
                                }

                                reader.moveUp();
                            }

                        }

                        reader.moveUp();

                    }

                    networkList.add(network);
                }

                reader.moveUp();

            }

        }

        return networkList;
    }

}
