/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model.transform;

import java.util.ArrayList;
import java.util.List;

import com.nifty.cloud.sdk.multiloadbalancer.model.ResultInstance;
import com.nifty.cloud.sdk.multiloadbalancer.model.ServerMember;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

/**
 * ServerMember変換クラス。<br />
 * このクラスはレスポンスXMLからServerMemberクラスを生成します。
 */
public class InstancesConverter implements Converter {

    private static final String ELEMENT_MEMBER = "member";
    private static final String ELEMENT_INSTANCE_EUNIQUE_ID = "InstanceUniqueId";
    private static final String ELEMENT_INSTANCE_ID = "InstanceId";
    private static final String ELEMENT_STATE = "State";

    @SuppressWarnings("rawtypes")
    @Override
    public boolean canConvert(Class type) {
        return type == ResultInstance.class;
    }

    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer,
        MarshallingContext context) {
        // 処理無し
    }

    /**
     * {@literal
     * InstancesをResultInstanceクラスに変換します。}
     *
     * @param reader
     *            XML読込リーダ
     * @param context
     * @return {@literal ResultInstanceオブジェクト}
     *
     * @see com.thoughtworks.xstream.converters.Converter#unmarshal(HierarchicalStreamReader,
     *      UnmarshallingContext)
     */
    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        
        List<ServerMember> list = new ArrayList<ServerMember>();

        ServerMember member = null;

        String name = null;

        while (reader.hasMoreChildren()) {

            reader.moveDown();

            name = reader.getNodeName();

            if (name.equals(ELEMENT_MEMBER)) {

                member = new ServerMember();

                while (reader.hasMoreChildren()) {

                    reader.moveDown();

                    name = reader.getNodeName();

                    if (name.equals(ELEMENT_INSTANCE_EUNIQUE_ID)) {
                        member.setInstanceUniqueId(reader.getValue());
                    } else if (name.equals(ELEMENT_INSTANCE_ID)) {
                        member.setInstanceId(reader.getValue());
                    }else if(name.equals(ELEMENT_STATE)) {
                        member.setState(reader.getValue());
                    }

                    reader.moveUp();

                }

                list.add(member);

            }

            reader.moveUp();

        }
        
        ResultInstance instance = new ResultInstance();
        instance.setMember(list);

        return instance;
    }

}
