/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.multiloadbalancer.model.transform;

import java.util.ArrayList;
import java.util.List;

import com.nifty.cloud.sdk.multiloadbalancer.model.Expectation;
import com.nifty.cloud.sdk.multiloadbalancer.model.ExpectationMember;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

/**
 * Expectation変換クラス。<br />
 * このクラスはレスポンスXMLのヘルスチェック期待値をExpectationに変換します。
 *
 */
public class ExpectationConverter implements Converter {

    private static final String ELEMENT_MEMBER = "member";
    private static final String ELEMENT_HTTP_CODE = "HttpCode";

    /**
     * 変換可能なクラスか判定します。
     *
     * @param type
     *            クラス
     * @return 変換可能な場合true, 変換不可能な場合false
     *
     * @see com.thoughtworks.xstream.converters.Converter#canConvert(Class)
     */
    @SuppressWarnings("rawtypes")
    @Override
    public boolean canConvert(Class type) {
        return type == Expectation.class;
    }

    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer,
        MarshallingContext context) {
        // 処理無し
    }

    /**
     * {@literal
     * ExpectationをExpectationクラスに変換します。}
     *
     * @param reader
     *            XML読込リーダ
     * @param context
     * @return {@literal Expectationオブジェクト}
     *
     * @see com.thoughtworks.xstream.converters.Converter#unmarshal(HierarchicalStreamReader,
     *      UnmarshallingContext)
     */
    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {

        String name = null;

        Expectation expectation = new Expectation();

        List<ExpectationMember> expectationMemberList =
            new ArrayList<ExpectationMember>();

        expectation.setMemberList(expectationMemberList);

        ExpectationMember expectationMember = null;

        expectation.setMemberList(expectationMemberList);

        while (reader.hasMoreChildren()) {

            reader.moveDown();

            name = reader.getNodeName();

            if (name.equals(ELEMENT_MEMBER)) {

                expectationMember = new ExpectationMember();

                reader.moveDown();

                name = reader.getNodeName();

                if (name.equals(ELEMENT_HTTP_CODE)) {
                    expectationMember.setHttpCode(reader.getValue());
                }

                reader.moveUp();

                expectationMemberList.add(expectationMember);

            }

            reader.moveUp();

        }

        return expectation;
    }

}
